/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00112", priority=Priority.MAJOR, tags={"error-handling"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class RawException_S00112_Check
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S00112";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S00112");
    private static final Set<String> RAW_EXCEPTIONS = ImmutableSet.of((Object)"Throwable", (Object)"Error", (Object)"Exception", (Object)"RuntimeException");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        if (!this.isOverride(tree)) {
            for (ExpressionTree throwClause : tree.throwsClauses()) {
                this.checkExceptionAndRaiseIssue((Tree)throwClause);
            }
        }
        super.visitMethod(tree);
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        if (tree.expression().is(Tree.Kind.NEW_CLASS)) {
            this.checkExceptionAndRaiseIssue(((NewClassTree)tree.expression()).identifier());
        }
        super.visitThrowStatement(tree);
    }

    private void checkExceptionAndRaiseIssue(Tree tree) {
        if (this.isRawException(tree)) {
            this.context.addIssue(tree, this.ruleKey, "Define and throw a dedicated exception instead of using a generic one.");
        }
    }

    private boolean isRawException(Tree tree) {
        return tree.is(Tree.Kind.IDENTIFIER) && RAW_EXCEPTIONS.contains(((IdentifierTree)tree).name());
    }

    private boolean isOverride(MethodTree tree) {
        for (AnnotationTree annotationTree : tree.modifiers().annotations()) {
            if (!annotationTree.annotationType().is(Tree.Kind.IDENTIFIER)) continue;
            IdentifierTree identifier = (IdentifierTree)annotationTree.annotationType();
            if (!Override.class.getSimpleName().equals(identifier.name())) continue;
            return true;
        }
        return false;
    }
}

