/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1612", priority=Priority.MINOR, tags={"java8"})
public class ReplaceLambdaByMethodRefCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1612";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1612");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitLambdaExpression(LambdaExpressionTree tree) {
        if (this.isMethodInvocation(tree.body()) || this.isBlockInvokingMethod(tree.body())) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Replace this lambda with a method reference.");
        }
        super.visitLambdaExpression(tree);
    }

    private boolean isMethodInvocation(Tree tree) {
        return tree != null && tree.is(Tree.Kind.METHOD_INVOCATION);
    }

    private boolean isBlockInvokingMethod(Tree tree) {
        if (this.isBlockWithOneStatement(tree)) {
            Tree statement = (Tree)((BlockTree)tree).body().get(0);
            return this.isExpressionStatementInvokingMethod(statement) || this.isReturnStatementInvokingMethod(statement);
        }
        return false;
    }

    private boolean isReturnStatementInvokingMethod(Tree statement) {
        return statement.is(Tree.Kind.RETURN_STATEMENT) && this.isMethodInvocation((Tree)((ReturnStatementTree)statement).expression());
    }

    private boolean isExpressionStatementInvokingMethod(Tree statement) {
        return statement.is(Tree.Kind.EXPRESSION_STATEMENT) && this.isMethodInvocation((Tree)((ExpressionStatementTree)statement).expression());
    }

    private boolean isBlockWithOneStatement(Tree tree) {
        return tree.is(Tree.Kind.BLOCK) && ((BlockTree)tree).body().size() == 1;
    }
}

