/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1656", priority=Priority.MAJOR, tags={"bug"})
public class SelfAssignementCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1656";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1656");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.is(Tree.Kind.ASSIGNMENT) && SyntacticEquivalence.areEquivalent((Tree)tree.expression(), (Tree)tree.variable())) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Remove or correct this useless self-assignment");
        }
        super.visitAssignmentExpression(tree);
    }
}

