/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceMethod;

@Rule(key="S1160", priority=Priority.MAJOR, tags={"error-handling"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ThrowsSeveralCheckedExceptionCheck
extends BytecodeVisitor {
    public static final String RULE_KEY = "S1160";
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitMethod(AsmMethod asmMethod) {
        List<String> thrownCheckedExceptions;
        if (asmMethod.isPublic() && !ThrowsSeveralCheckedExceptionCheck.isOverriden(asmMethod) && (thrownCheckedExceptions = this.getThrownCheckedExceptions(asmMethod)).size() > 1) {
            CheckMessage message = new CheckMessage((Object)this, "Refactor this method to throw at most one checked exception instead of: " + Joiner.on((String)", ").join(thrownCheckedExceptions), new Object[0]);
            SourceMethod sourceMethod = this.getSourceMethod(asmMethod);
            if (sourceMethod != null) {
                message.setLine(sourceMethod.getStartAtLine());
            }
            SourceFile file = this.getSourceFile(this.asmClass);
            file.log(message);
        }
    }

    private List<String> getThrownCheckedExceptions(AsmMethod asmMethod) {
        List thrownClasses = asmMethod.getThrows();
        if (thrownClasses.size() > 1) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (AsmClass thrownClass : thrownClasses) {
                if (ThrowsSeveralCheckedExceptionCheck.isSubClassOfRuntimeException(thrownClass)) continue;
                builder.add((Object)thrownClass.getDisplayName());
            }
            return builder.build();
        }
        return Collections.emptyList();
    }

    private static boolean isOverriden(AsmMethod method) {
        return ThrowsSeveralCheckedExceptionCheck.isOverridenFromClass(method) || ThrowsSeveralCheckedExceptionCheck.isOverridenFromInterface(method);
    }

    private static boolean isOverridenFromClass(AsmMethod method) {
        AsmClass superClass = method.getParent().getSuperClass();
        return superClass != null && superClass.getMethod(method.getKey()) != null;
    }

    private static boolean isOverridenFromInterface(AsmMethod method) {
        for (AsmClass implementedInterface : method.getParent().getImplementedInterfaces()) {
            if (implementedInterface.getMethod(method.getKey()) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isSubClassOfRuntimeException(AsmClass thrownClass) {
        for (AsmClass current = thrownClass; current != null; current = current.getSuperClass()) {
            if (!"java/lang/RuntimeException".equals(current.getInternalName())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "S1160 rule";
    }
}

