/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1172", priority=Priority.MAJOR, tags={"unused"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UnusedMethodParameterCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1172";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1172");
    private JavaFileScannerContext context;
    private SemanticModel semanticModel;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        if (this.semanticModel != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitMethod(MethodTree tree) {
        super.visitMethod(tree);
        if (tree.block() != null && !this.isMainMethod(tree) && !this.isOverriden(tree)) {
            ArrayList unused = Lists.newArrayList();
            for (VariableTree var : tree.parameters()) {
                Symbol sym = this.semanticModel.getSymbol((Tree)var);
                if (sym == null || !this.semanticModel.getUsages(sym).isEmpty()) continue;
                unused.add(var.simpleName().name());
            }
            if (!unused.isEmpty()) {
                this.context.addIssue((Tree)tree, this.ruleKey, "Remove the unused method parameter(s) \"" + Joiner.on((String)",").join((Iterable)unused) + "\".");
            }
        }
    }

    private boolean isMainMethod(MethodTree tree) {
        return this.isPublicStatic(tree) && this.isCalledMain(tree) && this.returnsVoid(tree) && this.hasStringArrayParameter(tree);
    }

    private boolean hasStringArrayParameter(MethodTree tree) {
        return this.hasOneParameter(tree) && this.isParameterStringArray(tree);
    }

    private boolean isParameterStringArray(MethodTree tree) {
        VariableTree variableTree = (VariableTree)tree.parameters().get(0);
        boolean result = false;
        if (variableTree.type().is(Tree.Kind.ARRAY_TYPE)) {
            ArrayTypeTree arrayTypeTree = (ArrayTypeTree)variableTree.type();
            Type arrayType = ((AbstractTypedTree)arrayTypeTree.type()).getType();
            result = arrayType.isTagged(10) && "String".equals(((Type.ClassType)arrayType).getSymbol().getName());
        }
        return result;
    }

    private boolean isPublicStatic(MethodTree tree) {
        return tree.modifiers().modifiers().contains(Modifier.STATIC) && tree.modifiers().modifiers().contains(Modifier.PUBLIC);
    }

    private boolean isCalledMain(MethodTree tree) {
        return "main".equals(tree.simpleName().name());
    }

    private boolean returnsVoid(MethodTree tree) {
        Symbol.MethodSymbol methodSymbol = ((MethodTreeImpl)tree).getSymbol();
        return methodSymbol != null && methodSymbol.getReturnType().getType().isTagged(9);
    }

    private boolean hasOneParameter(MethodTree tree) {
        return tree.parameters().size() == 1;
    }

    private boolean isOverriden(MethodTree tree) {
        for (AnnotationTree annotationTree : tree.modifiers().annotations()) {
            Tree annotationType = annotationTree.annotationType();
            if (!annotationType.is(Tree.Kind.IDENTIFIER) || !"Override".equals(((IdentifierTree)annotationType).name())) continue;
            return true;
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)this.semanticModel.getSymbol((Tree)tree);
        Type.ClassType superClass = (Type.ClassType)methodSymbol.enclosingClass().getSuperclass();
        while (superClass != null) {
            List symbols = superClass.getSymbol().members().lookup(tree.simpleName().name());
            for (Symbol symbol : symbols) {
                if (!symbol.isKind(16)) continue;
                return true;
            }
            superClass = (Type.ClassType)superClass.getSymbol().getSuperclass();
        }
        return false;
    }
}

