/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WildcardTree;

@Rule(key="S1452", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class WildcardReturnParameterTypeCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1452";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1452");
    private JavaFileScannerContext context;
    private boolean inReturnStatement;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.inReturnStatement = false;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        this.inReturnStatement = true;
        this.scan(tree.returnType());
        this.inReturnStatement = false;
        super.visitMethod(tree);
    }

    public void visitWildcard(WildcardTree tree) {
        if (this.inReturnStatement) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Remove usage of generic wildcard type.");
        }
    }
}

