/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.resources.Resource;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.plugins.java.bridges.Bridge;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;
import org.sonar.squid.measures.MetricDef;

public class FunctionsBridge
extends Bridge {
    private static final Number[] LIMITS = new Number[]{1, 2, 4, 6, 8, 10, 12};
    private int methods;
    private int accessors;
    private int complexityInMethods;
    private RangeDistributionBuilder methodComplexityDistribution;

    @Override
    public void onFile(SourceFile squidFile, Resource sonarFile) {
        this.methods = 0;
        this.complexityInMethods = 0;
        this.accessors = 0;
        this.methodComplexityDistribution = new RangeDistributionBuilder(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, LIMITS);
        this.visit((SourceCode)squidFile);
        this.context.saveMeasure(sonarFile, new Measure(CoreMetrics.FUNCTIONS, Double.valueOf(this.methods)));
        this.context.saveMeasure(sonarFile, new Measure(CoreMetrics.ACCESSORS, Double.valueOf(this.accessors)));
        this.context.saveMeasure(sonarFile, new Measure(CoreMetrics.COMPLEXITY_IN_FUNCTIONS, Double.valueOf(this.complexityInMethods)));
        this.context.saveMeasure(sonarFile, this.methodComplexityDistribution.build(true).setPersistenceMode(PersistenceMode.MEMORY));
    }

    private void visit(SourceCode squidCode) {
        if (squidCode.hasChildren()) {
            for (SourceCode code : squidCode.getChildren()) {
                if (code.isType(SourceClass.class)) {
                    if (!this.isNotAnonymousInnerClass(code)) continue;
                    this.visit(code);
                    continue;
                }
                if (!code.isType(SourceMethod.class)) continue;
                if (((SourceMethod)code).isAccessor()) {
                    ++this.accessors;
                } else {
                    ++this.methods;
                    int complexity = code.getInt((MetricDef)JavaMetric.COMPLEXITY);
                    this.complexityInMethods += complexity;
                    this.methodComplexityDistribution.add((Number)complexity);
                }
                this.visit(code);
            }
        }
    }

    private boolean isNotAnonymousInnerClass(SourceCode squidClass) {
        return squidClass.getInt((MetricDef)JavaMetric.CLASSES) >= 1;
    }
}

