/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="FunctionDeclarationsWithinBlocks", priority=Priority.BLOCKER)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class FunctionDeclarationsWithinBlocksCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).statementList});
    }

    public void visitNode(AstNode astNode) {
        for (AstNode functionDeclarationNode : astNode.findDirectChildren(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).functionDeclaration})) {
            this.getContext().createLineViolation((CodeCheck)this, "Do not use function declarations within blocks.", functionDeclarationNode, new Object[0]);
        }
    }
}

