/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="FutureReservedWords", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class FutureReservedWordsCheck
extends SquidCheck<LexerlessGrammar> {
    private static final Set<String> FUTURE_RESERVED_WORDS = ImmutableSet.of((Object)"implements", (Object)"interface", (Object)"let", (Object)"package", (Object)"private", (Object)"protected", (Object[])new String[]{"public", "static", "yield"});

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER});
    }

    public void visitNode(AstNode astNode) {
        String value = astNode.getTokenValue();
        if (FUTURE_RESERVED_WORDS.contains(value)) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename '" + value + "' identifier to prevent potential conflicts with future evolutions of the JavaScript language.", astNode, new Object[0]);
        }
    }
}

