/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="LineLength", priority=Priority.MINOR)
public class LineLengthCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private static final int DEFAULT_MAXIMUM_LINE_LENHGTH = 80;
    @RuleProperty(key="maximumLineLength", defaultValue="80")
    public int maximumLineLength = 80;
    private Token previousToken;

    public int getMaximumLineLength() {
        return this.maximumLineLength;
    }

    public void visitFile(AstNode astNode) {
        this.previousToken = null;
    }

    public void leaveFile(AstNode astNode) {
        this.previousToken = null;
    }

    public void visitToken(Token token) {
        if (!token.isGeneratedCode()) {
            int length;
            if (this.previousToken != null && this.previousToken.getLine() != token.getLine() && (length = this.previousToken.getColumn() + this.previousToken.getValue().length()) > this.getMaximumLineLength()) {
                this.getContext().createLineViolation((CodeCheck)this, "The line contains {0,number,integer} characters which is greater than {1,number,integer} authorized.", this.previousToken.getLine(), new Object[]{length, this.getMaximumLineLength()});
            }
            this.previousToken = token;
        }
    }
}

