/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Objects;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="TooManyBreakOrContinueInLoop", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class TooManyBreakOrContinueInLoopCheck
extends SquidCheck<LexerlessGrammar> {
    private Stack<JumpTarget> jumpTargets;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.ITERATION_STATEMENT, EcmaScriptGrammar.BREAK_STATEMENT, EcmaScriptGrammar.CONTINUE_STATEMENT, EcmaScriptGrammar.SWITCH_STATEMENT, EcmaScriptGrammar.LABELLED_STATEMENT});
    }

    public void visitFile(AstNode astNode) {
        this.jumpTargets = new Stack();
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.LABELLED_STATEMENT})) {
            String label = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}).getTokenValue();
            this.jumpTargets.push(new JumpTarget(label));
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.BREAK_STATEMENT, EcmaScriptGrammar.CONTINUE_STATEMENT})) {
            AstNode labelNode = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER});
            String label = labelNode == null ? null : labelNode.getTokenValue();
            for (int i = this.jumpTargets.size() - 1; i >= 0; --i) {
                JumpTarget jumpTarget = (JumpTarget)this.jumpTargets.get(i);
                jumpTarget.jumps++;
                if (!Objects.equal((Object)label, (Object)jumpTarget.label)) {
                    continue;
                }
                break;
            }
        } else {
            this.jumpTargets.push(new JumpTarget());
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.isNot(new AstNodeType[]{EcmaScriptGrammar.BREAK_STATEMENT, EcmaScriptGrammar.CONTINUE_STATEMENT})) {
            JumpTarget jumpTarget = this.jumpTargets.pop();
            if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.ITERATION_STATEMENT}) && jumpTarget.jumps > 1) {
                this.getContext().createLineViolation((CodeCheck)this, "Refactor this loop to prevent having more than one 'break' or 'continue' statement.", astNode, new Object[0]);
            }
        }
    }

    public void leaveFile(AstNode astNode) {
        this.jumpTargets = null;
    }

    private static class JumpTarget {
        private final String label;
        private int jumps;

        public JumpTarget() {
            this.label = null;
        }

        public JumpTarget(String label) {
            this.label = label;
        }
    }
}

