/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Map;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="UnusedFunctionArgument", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UnusedFunctionArgumentCheck
extends SquidCheck<LexerlessGrammar> {
    private Scope currentScope;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FORMAL_PARAMETER_LIST, EcmaScriptGrammar.PRIMARY_EXPRESSION});
    }

    public void visitFile(AstNode astNode) {
        this.currentScope = null;
    }

    public void visitNode(AstNode astNode) {
        AstNode identifierNode;
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            this.currentScope = new Scope(this.currentScope);
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER_LIST})) {
            for (AstNode identifierNode2 : astNode.getChildren(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER})) {
                this.currentScope.declare(identifierNode2);
            }
        } else if (this.currentScope != null && astNode.is(new AstNodeType[]{EcmaScriptGrammar.PRIMARY_EXPRESSION}) && (identifierNode = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER})) != null) {
            this.currentScope.use(identifierNode);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            for (Map.Entry entry : this.currentScope.arguments.entrySet()) {
                if (((Argument)entry.getValue()).usages != 0) continue;
                this.getContext().createLineViolation((CodeCheck)this, "Remove the declaration of the unused '" + (String)entry.getKey() + "' argument.", ((Argument)entry.getValue()).declaration, new Object[0]);
            }
            this.currentScope = this.currentScope.outerScope;
        }
    }

    public void leaveFile(AstNode astNode) {
        this.currentScope = null;
    }

    private static class Scope {
        private final Scope outerScope;
        private final Map<String, Argument> arguments;

        public Scope(Scope outerScope) {
            this.outerScope = outerScope;
            this.arguments = Maps.newHashMap();
        }

        private void declare(AstNode astNode) {
            Preconditions.checkState((boolean)astNode.is(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}));
            String identifier = astNode.getTokenValue();
            this.arguments.put(identifier, new Argument(astNode, 0));
        }

        private void use(AstNode astNode) {
            Preconditions.checkState((boolean)astNode.is(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}));
            String identifier = astNode.getTokenValue();
            Scope scope = this;
            while (scope != null) {
                Argument arg = scope.arguments.get(identifier);
                if (arg != null) {
                    ++arg.usages;
                    return;
                }
                scope = scope.outerScope;
            }
        }
    }

    private static class Argument {
        final AstNode declaration;
        int usages;

        public Argument(AstNode declaration, int usages) {
            this.declaration = declaration;
            this.usages = usages;
        }
    }
}

