/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Map;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="VariableDeclarationAfterUsage", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class VariableDeclarationAfterUsageCheck
extends SquidCheck<LexerlessGrammar> {
    private Scope currentScope;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN, EcmaScriptGrammar.PRIMARY_EXPRESSION, EcmaScriptGrammar.FORMAL_PARAMETER_LIST});
    }

    public void visitFile(AstNode astNode) {
        this.currentScope = new Scope();
    }

    public void visitNode(AstNode astNode) {
        AstNode identifierNode;
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            this.currentScope = new Scope(this.currentScope);
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER_LIST})) {
            for (AstNode identifierNode2 : astNode.getChildren(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER})) {
                this.currentScope.declare(identifierNode2);
            }
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN})) {
            this.currentScope.declare(astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}));
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.PRIMARY_EXPRESSION}) && (identifierNode = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER})) != null) {
            this.currentScope.use(identifierNode);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            this.checkCurrentScope();
            for (Map.Entry<String, AstNode> entry : this.currentScope.firstUsage.entrySet()) {
                if (this.currentScope.firstDeclaration.containsKey(entry.getKey())) continue;
                this.currentScope.outerScope.use(entry.getValue());
            }
            this.currentScope = this.currentScope.outerScope;
        }
    }

    private void checkCurrentScope() {
        for (Map.Entry<String, AstNode> entry : this.currentScope.firstDeclaration.entrySet()) {
            AstNode declaration = entry.getValue();
            AstNode usage = this.currentScope.firstUsage.get(entry.getKey());
            if (usage == null || usage.getTokenLine() >= declaration.getTokenLine()) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Variable '" + entry.getKey() + "' referenced before declaration.", usage, new Object[0]);
        }
    }

    public void leaveFile(AstNode astNode) {
        this.checkCurrentScope();
        this.currentScope = null;
    }

    private static class Scope {
        private final Scope outerScope;
        Map<String, AstNode> firstDeclaration = Maps.newHashMap();
        Map<String, AstNode> firstUsage = Maps.newHashMap();

        public Scope() {
            this.outerScope = null;
        }

        public Scope(Scope outerScope) {
            this.outerScope = outerScope;
        }

        private void declare(AstNode astNode) {
            Preconditions.checkState((boolean)astNode.is(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}));
            String identifier = astNode.getTokenValue();
            if (!this.firstDeclaration.containsKey(identifier)) {
                this.firstDeclaration.put(identifier, astNode);
            }
        }

        private void use(AstNode astNode) {
            Preconditions.checkState((boolean)astNode.is(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}));
            String identifier = astNode.getTokenValue();
            if (!this.firstUsage.containsKey(identifier)) {
                this.firstUsage.put(identifier, astNode);
            }
        }
    }
}

