/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1472", priority=Priority.CRITICAL, tags={"pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class FunctionCallArgumentsOnNewLineCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.CALL_EXPRESSION});
    }

    public void visitNode(AstNode astNode) {
        AstNode arguments = astNode.getFirstChild(new AstNodeType[]{Tree.Kind.ARGUMENTS});
        int calleLine = arguments.getPreviousSibling().getLastChild().getLastToken().getLine();
        if (calleLine != arguments.getTokenLine()) {
            this.getContext().createLineViolation((CodeCheck)this, "Make those call arguments start on line {0}", arguments, new Object[]{calleLine});
        }
    }
}

