/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="FunctionDefinitionInsideLoop", priority=Priority.MAJOR, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class FunctionDefinitionInsideLoopCheck
extends SquidCheck<LexerlessGrammar> {
    private Stack<Integer> stack;

    public void init() {
        this.subscribeTo((AstNodeType[])CheckUtils.iterationStatementsArray());
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.ITERATION_STATEMENT, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_DECLARATION});
    }

    public void visitFile(AstNode astNode) {
        this.stack = new Stack();
        this.stack.push(0);
    }

    public void visitNode(AstNode astNode) {
        if (CheckUtils.isIterationStatement(astNode)) {
            this.stack.push(this.stack.pop() + 1);
        } else {
            if (this.stack.peek() > 0) {
                this.getContext().createLineViolation((CodeCheck)this, "Define this function outside of a loop.", astNode, new Object[0]);
            }
            this.stack.add(0);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (CheckUtils.isIterationStatement(astNode)) {
            this.stack.push(this.stack.pop() - 1);
        } else {
            this.stack.pop();
        }
    }

    public void leaveFile(AstNode astNode) {
        this.stack = null;
    }
}

