/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.regex.Pattern;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S100", priority=Priority.MAJOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class FunctionNameCheck
extends SquidCheck<LexerlessGrammar> {
    public static final String DEFAULT = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";

    public void init() {
        this.pattern = Pattern.compile(this.format);
        this.subscribeTo(new AstNodeType[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.GENERATOR_METHOD, Tree.Kind.METHOD});
    }

    public void visitNode(AstNode astNode) {
        String identifier = astNode.getFirstChild(new AstNodeType[]{Tree.Kind.BINDING_IDENTIFIER, Tree.Kind.IDENTIFIER_NAME}).getTokenValue();
        if (!this.pattern.matcher(identifier).matches()) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename this ''{0}'' function to match the regular expression {1}", astNode, new Object[]{identifier, this.format});
        }
    }
}

