/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.statement.IfStatementTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1145", priority=Priority.MAJOR, tags={"bug", "cwe", "misra", "security"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class IfConditionalAlwaysTrueOrFalseCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.IF_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        IfStatementTree statement = (IfStatementTree)astNode;
        if (statement.condition().is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this \"if\" statement.", astNode, new Object[0]);
        }
    }
}

