/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.declaration;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.SeparatedList;
import org.sonar.javascript.model.implementations.declaration.ObjectBindingPatternTreeImpl;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.ArrayBindingPatternTree;
import org.sonar.javascript.model.interfaces.declaration.BindingElementTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.expression.RestElementTree;
import org.sonar.javascript.parser.sslr.Optional;

public class ArrayBindingPatternTreeImpl
extends JavaScriptTree
implements ArrayBindingPatternTree {
    private final InternalSyntaxToken openBracketToken;
    private final SeparatedList<Optional<BindingElementTree>> elements;
    private final InternalSyntaxToken closeBracketToken;

    public ArrayBindingPatternTreeImpl(InternalSyntaxToken openBracketToken, SeparatedList<Optional<BindingElementTree>> elements, List<AstNode> children, InternalSyntaxToken closeBracketToken) {
        super(Tree.Kind.ARRAY_BINDING_PATTERN);
        this.openBracketToken = openBracketToken;
        this.elements = elements;
        this.closeBracketToken = closeBracketToken;
        this.addChild(openBracketToken);
        for (AstNode child : children) {
            this.addChild(child);
        }
        this.addChild(closeBracketToken);
    }

    @Override
    public InternalSyntaxToken openBracketToken() {
        return this.openBracketToken;
    }

    @Override
    public SeparatedList<Optional<BindingElementTree>> elements() {
        return this.elements;
    }

    @Override
    public InternalSyntaxToken closeBracketToken() {
        return this.closeBracketToken;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ARRAY_BINDING_PATTERN;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        ArrayList nonElidedElements = Lists.newArrayList();
        for (Optional<BindingElementTree> e : this.elements) {
            if (!e.isPresent()) continue;
            nonElidedElements.add(e.get());
        }
        return Iterators.concat((Iterator[])new Iterator[]{nonElidedElements.iterator()});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitArrayBindingPattern(this);
    }

    public List<IdentifierTree> bindingIdentifiers() {
        ArrayList bindingIdentifiers = Lists.newArrayList();
        for (Optional<BindingElementTree> element : this.elements) {
            if (!element.isPresent()) continue;
            if (element.get().is(Tree.Kind.BINDING_IDENTIFIER)) {
                bindingIdentifiers.add((IdentifierTree)element.get());
                continue;
            }
            if (element.get().is(Tree.Kind.REST_ELEMENT)) {
                bindingIdentifiers.add((IdentifierTree)((RestElementTree)((Object)element.get())).element());
                continue;
            }
            if (element.get().is(Tree.Kind.OBJECT_BINDING_PATTERN)) {
                bindingIdentifiers.addAll(((ObjectBindingPatternTreeImpl)element.get()).bindingIdentifiers());
                continue;
            }
            bindingIdentifiers.addAll(((ArrayBindingPatternTreeImpl)element.get()).bindingIdentifiers());
        }
        return bindingIdentifiers;
    }
}

