/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.ast.resolve;

import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolDeclaration;
import org.sonar.javascript.model.interfaces.Tree;

public class Scope {
    private Scope outer;
    private final Tree tree;
    protected Map<String, Symbol> symbols = Maps.newHashMap();

    public Scope(Scope outer, Tree tree) {
        this.outer = outer;
        this.tree = tree;
    }

    public Tree getTree() {
        return this.tree;
    }

    public Scope outer() {
        return this.outer;
    }

    public Symbol createSymbol(String name, SymbolDeclaration declaration, Symbol.Kind kind) {
        Symbol symbol = this.symbols.get(name);
        if (symbol != null) {
            symbol.declarations().add(declaration);
        } else {
            symbol = new Symbol(name, declaration, kind);
            this.symbols.put(name, symbol);
        }
        return symbol;
    }

    public Symbol createBuildInSymbol(String name, Symbol.Kind kind) {
        Symbol symbol = this.symbols.get(name);
        if (symbol != null) {
            throw new IllegalStateException(String.format("Build-in \"symbol\" %s already exists in the current scope.", name));
        }
        symbol = new Symbol(name, new SymbolDeclaration(this.tree, SymbolDeclaration.Kind.BUILD_IN), kind, true);
        this.symbols.put(name, symbol);
        return symbol;
    }

    public Symbol lookupSymbol(String name) {
        Scope scope = this;
        while (scope != null && !scope.symbols.containsKey(name)) {
            scope = scope.outer;
        }
        return scope == null ? null : scope.symbols.get(name);
    }

    public List<Symbol> getSymbols(Symbol.Kind kind) {
        LinkedList<Symbol> result = new LinkedList<Symbol>();
        for (Symbol symbol : this.symbols.values()) {
            if (!symbol.is(kind)) continue;
            result.add(symbol);
        }
        return result;
    }

    public Scope globalScope() {
        Scope scope = this;
        while (scope.outer != null) {
            scope = scope.outer;
        }
        return scope;
    }

    public String toString() {
        return "Scope{tree=" + this.tree + ", symbols=" + this.symbols.size() + '}';
    }
}

