/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.ast.resolve;

import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.source.Symbolizable;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.ast.resolve.Scope;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolDeclaration;
import org.sonar.javascript.ast.resolve.SymbolDeclarationVisitor;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.resolve.Usage;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.highlighter.HighlightSymbolTableBuilder;
import org.sonar.javascript.highlighter.SourceFileOffsets;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.FunctionDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.MethodDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.javascript.model.interfaces.expression.ArrowFunctionTree;
import org.sonar.javascript.model.interfaces.expression.AssignmentExpressionTree;
import org.sonar.javascript.model.interfaces.expression.FunctionExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.expression.UnaryExpressionTree;
import org.sonar.javascript.model.interfaces.statement.CatchBlockTree;
import org.sonar.javascript.model.interfaces.statement.ForInStatementTree;
import org.sonar.javascript.model.interfaces.statement.ForOfStatementTree;

public class SymbolVisitor
extends BaseTreeVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(SymbolVisitor.class);
    private final Symbolizable symbolizable;
    private final SourceFileOffsets sourceFileOffsets;
    private SymbolModel symbolModel;
    private Scope currentScope;

    public SymbolVisitor(SymbolModel symbolModel, @Nullable Symbolizable symbolizable, @Nullable SourceFileOffsets sourceFileOffsets) {
        this.symbolModel = symbolModel;
        this.currentScope = null;
        this.symbolizable = symbolizable;
        this.sourceFileOffsets = sourceFileOffsets;
    }

    @Override
    public void visitScript(ScriptTree tree) {
        new SymbolDeclarationVisitor(this.symbolModel).visitScript(tree);
        this.enterScope(tree);
        this.addBuildInSymbols();
        super.visitScript(tree);
        this.leaveScope();
        this.highlightSymbols();
    }

    private void addBuildInSymbols() {
        this.createBuildInSymbolForScope("eval", this.currentScope.globalScope(), Symbol.Kind.FUNCTION);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.enterScope(tree);
        super.visitMethodDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        this.enterScope(tree);
        super.visitCatchBlock(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.enterScope(tree);
        super.visitFunctionDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.enterScope(tree);
        super.visitFunctionExpression(tree);
        this.leaveScope();
    }

    @Override
    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.enterScope(tree);
        super.visitArrowFunction(tree);
        this.leaveScope();
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.variable() instanceof IdentifierTree) {
            IdentifierTree identifier = (IdentifierTree)tree.variable();
            Usage.Kind usageKind = Usage.Kind.WRITE;
            if (!tree.operator().text().equals(EcmaScriptPunctuator.EQU.getValue())) {
                usageKind = Usage.Kind.READ_WRITE;
            }
            if (!this.addUsageFor(identifier, tree, usageKind)) {
                Symbol symbol = this.createSymbolForScope(identifier.name(), identifier, this.currentScope.globalScope(), Symbol.Kind.VARIABLE);
                Usage.createInit(this.symbolModel, symbol, identifier, tree, usageKind);
            }
            this.scan(tree.expression());
        } else {
            super.visitAssignmentExpression(tree);
        }
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        if (tree.is(Tree.Kind.IDENTIFIER_REFERENCE)) {
            this.addUsageFor(tree, null, Usage.Kind.READ);
        }
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (this.isIncDec(tree) && tree.expression().is(Tree.Kind.IDENTIFIER_REFERENCE)) {
            this.addUsageFor((IdentifierTree)tree.expression(), null, Usage.Kind.READ_WRITE);
        } else {
            super.visitUnaryExpression(tree);
        }
    }

    private boolean isIncDec(UnaryExpressionTree tree) {
        return tree.is(Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT);
    }

    @Override
    public void visitForOfStatement(ForOfStatementTree tree) {
        IdentifierTree identifier;
        if (tree.variableOrExpression() instanceof IdentifierTree && !this.addUsageFor(identifier = (IdentifierTree)tree.variableOrExpression(), null, Usage.Kind.WRITE)) {
            this.createSymbolForScope(identifier.name(), identifier, this.currentScope.globalScope(), Symbol.Kind.VARIABLE);
        }
        super.visitForOfStatement(tree);
    }

    @Override
    public void visitForInStatement(ForInStatementTree tree) {
        if (tree.variableOrExpression() instanceof IdentifierTree) {
            IdentifierTree identifier = (IdentifierTree)tree.variableOrExpression();
            if (!this.addUsageFor(identifier, null, Usage.Kind.WRITE)) {
                this.createSymbolForScope(identifier.name(), identifier, this.currentScope.globalScope(), Symbol.Kind.VARIABLE);
            }
            this.scan(tree.expression());
            this.scan(tree.statement());
        } else {
            super.visitForInStatement(tree);
        }
    }

    private void leaveScope() {
        if (this.currentScope != null) {
            this.currentScope = this.currentScope.outer();
        }
    }

    private Symbol createSymbolForScope(String name, IdentifierTree tree, Scope scope, Symbol.Kind kind) {
        Symbol symbol = scope.createSymbol(name, new SymbolDeclaration(tree, SymbolDeclaration.Kind.FOR_OF), kind);
        this.symbolModel.setScopeForSymbol(symbol, scope);
        this.symbolModel.setScopeFor(tree, scope);
        return symbol;
    }

    private Symbol createBuildInSymbolForScope(String name, Scope scope, Symbol.Kind kind) {
        Symbol symbol = scope.createBuildInSymbol(name, kind);
        this.symbolModel.setScopeForSymbol(symbol, scope);
        this.symbolModel.setScopeFor(scope.getTree(), scope);
        return symbol;
    }

    private void enterScope(Tree tree) {
        this.currentScope = this.symbolModel.getScopeFor(tree);
    }

    private boolean addUsageFor(IdentifierTree identifier, @Nullable Tree usageTree, Usage.Kind kind) {
        Symbol symbol = this.currentScope.lookupSymbol(identifier.name());
        if (symbol != null) {
            if (usageTree != null) {
                Usage.create(this.symbolModel, symbol, identifier, usageTree, kind);
            } else {
                Usage.create(this.symbolModel, symbol, identifier, kind);
            }
            return true;
        }
        return false;
    }

    private void highlightSymbols() {
        if (this.symbolizable != null) {
            this.symbolizable.setSymbolTable(HighlightSymbolTableBuilder.build(this.symbolizable, this.symbolModel, this.sourceFileOffsets));
        } else {
            LOG.warn("Symbol in source view will not be highlighted.");
        }
    }
}

