/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class IdentifierTreeImpl
extends JavaScriptTree
implements IdentifierTree {
    private final InternalSyntaxToken nameToken;
    private final Tree.Kind kind;

    public IdentifierTreeImpl(Tree.Kind kind, InternalSyntaxToken nameToken) {
        super(kind, nameToken.getToken());
        this.kind = kind;
        this.nameToken = (InternalSyntaxToken)Preconditions.checkNotNull((Object)nameToken);
        this.addChild(nameToken);
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public SyntaxToken identifierToken() {
        return this.nameToken;
    }

    @Override
    public String name() {
        return this.identifierToken().text();
    }

    public String toString() {
        return this.name();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.nameToken);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitIdentifier(this);
    }
}

