/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.jstestdriver;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jfree.util.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.javascript.core.JavaScript;
import org.sonar.plugins.surefire.api.AbstractSurefireParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsTestDriverSensor
implements Sensor {
    protected JavaScript javascript;
    private static final Logger LOG = LoggerFactory.getLogger(JsTestDriverSensor.class);

    public JsTestDriverSensor(JavaScript javascript) {
        this.javascript = javascript;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.javascript.equals(project.getLanguage()) && StringUtils.isNotBlank((String)this.javascript.getSettings().getString("sonar.javascript.jstestdriver.reportsPath"));
    }

    public void analyse(Project project, SensorContext context) {
        String jsTestDriverFolder = this.javascript.getSettings().getString("sonar.javascript.jstestdriver.reportsPath");
        this.collect(project, context, new File(project.getFileSystem().getBasedir(), jsTestDriverFolder));
    }

    protected void collect(final Project project, final SensorContext context, File reportsDir) {
        LOG.debug("Parsing JsTestDriver run results in Surefile format from folder {}", (Object)reportsDir);
        new AbstractSurefireParser(){

            protected Resource<?> getUnitTestResource(String classKey) {
                org.sonar.api.resources.File unitTestFileResource = JsTestDriverSensor.this.getUnitTestFileResource(classKey);
                unitTestFileResource.setLanguage((Language)JsTestDriverSensor.this.javascript);
                unitTestFileResource.setQualifier("UTS");
                LOG.debug("Adding unittest resource: {}", (Object)unitTestFileResource.toString());
                List testDirectories = project.getFileSystem().getTestDirs();
                File unitTestFile = JsTestDriverSensor.this.getUnitTestFile(testDirectories, JsTestDriverSensor.this.getUnitTestFileName(classKey));
                String source = "";
                try {
                    source = FileUtils.readFileToString((File)unitTestFile, (String)project.getFileSystem().getSourceCharset().name());
                }
                catch (IOException e) {
                    source = "Could not find source for unit test: " + classKey + " in any of test directories";
                    Log.debug((Object)source, (Exception)e);
                }
                context.saveSource((Resource)unitTestFileResource, source);
                return unitTestFileResource;
            }
        }.collect(project, context, reportsDir);
    }

    protected org.sonar.api.resources.File getUnitTestFileResource(String classKey) {
        return new org.sonar.api.resources.File(classKey.replaceAll("\\.", "/") + ".js");
    }

    protected String getUnitTestFileName(String className) {
        String fileName = className.substring(className.indexOf(46) + 1);
        fileName = fileName.replace('.', '/');
        fileName = fileName + ".js";
        return fileName;
    }

    protected File getUnitTestFile(List<File> testDirectories, String name) {
        File dir;
        File unitTestFile = new File("");
        Iterator<File> i$ = testDirectories.iterator();
        while (i$.hasNext() && !(unitTestFile = new File(dir = i$.next(), name)).exists()) {
        }
        return unitTestFile;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

