/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.unittest.jstestdriver;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.plugins.javascript.unittest.surefireparser.AbstractSurefireParser;

public class JsTestDriverSensor
implements Sensor {
    protected ModuleFileSystem fileSystem;
    protected Settings settings;
    private static final Logger LOG = LoggerFactory.getLogger(JsTestDriverSensor.class);

    public JsTestDriverSensor(ModuleFileSystem fileSystem, Settings settings) {
        this.fileSystem = fileSystem;
        this.settings = settings;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return StringUtils.isNotBlank((String)this.getReportsDirectoryPath()) && ("js".equals(project.getLanguageKey()) || StringUtils.isBlank((String)project.getLanguageKey()) && !this.fileSystem.files(FileQuery.onSource().onLanguage(new String[]{"js"})).isEmpty());
    }

    public void analyse(Project project, SensorContext context) {
        this.collect(project, context, this.getIOFile(this.getReportsDirectoryPath()));
    }

    protected void collect(final Project project, final SensorContext context, File reportsDir) {
        LOG.info("Parsing Unit Test run results in Surefire format from folder {}", (Object)reportsDir);
        new AbstractSurefireParser(){

            @Override
            protected Resource getUnitTestResource(String classKey) {
                File unitTestFile = JsTestDriverSensor.this.getUnitTestFile(JsTestDriverSensor.this.fileSystem.testDirs(), JsTestDriverSensor.this.getUnitTestFileName(classKey));
                org.sonar.api.resources.File sonarFile = org.sonar.api.resources.File.fromIOFile((File)unitTestFile, (Project)project);
                if (sonarFile == null) {
                    sonarFile = org.sonar.api.resources.File.fromIOFile((File)unitTestFile, (List)JsTestDriverSensor.this.fileSystem.testDirs());
                }
                return context.getResource((Resource)sonarFile);
            }
        }.collect(context, reportsDir);
    }

    protected String getUnitTestFileName(String className) {
        String fileName = className.substring(className.indexOf(46) + 1);
        fileName = fileName.replace('.', '/');
        fileName = fileName + ".js";
        return fileName;
    }

    protected File getUnitTestFile(List<File> testDirectories, String name) {
        File dir;
        File unitTestFile = new File("");
        Iterator<File> i$ = testDirectories.iterator();
        while (i$.hasNext() && !(unitTestFile = new File(dir = i$.next(), name)).exists()) {
        }
        return unitTestFile;
    }

    protected File getIOFile(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.fileSystem.baseDir(), path);
        }
        return file;
    }

    protected String getReportsDirectoryPath() {
        return this.settings.getString("sonar.javascript.jstestdriver.reportsPath");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

