/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressReport
implements Runnable {
    private final long period;
    private final Logger logger;
    private int files;
    private int count;
    private File currentFile;
    private final Thread thread;

    public ProgressReport(String threadName, long period, Logger logger) {
        this.period = period;
        this.logger = logger;
        this.thread = new Thread(this);
        this.thread.setName(threadName);
    }

    public ProgressReport(String threadName, long period) {
        this(threadName, period, LoggerFactory.getLogger(ProgressReport.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ProgressReport progressReport;
        while (!Thread.interrupted()) {
            try {
                Thread.sleep(this.period);
                progressReport = this;
                synchronized (progressReport) {
                    this.logger.info(this.count + "/" + this.files + " files analyzed, current is " + this.currentFile.getAbsolutePath());
                }
            }
            catch (InterruptedException e) {
                this.thread.interrupt();
            }
        }
        progressReport = this;
        synchronized (progressReport) {
            this.logger.info(this.files + "/" + this.files + " source files analyzed");
        }
    }

    public synchronized void start(int files) {
        this.files = files;
        this.logger.info(files + " source files to be analyzed");
        this.thread.start();
    }

    public synchronized void nextFile(File currentFile) {
        ++this.count;
        this.currentFile = currentFile;
    }

    public synchronized void stop() {
        this.thread.interrupt();
    }
}

