/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.ast.visitors;

import com.google.common.base.Preconditions;
import java.io.File;
import org.sonar.javascript.ast.visitors.AstTreeVisitorContext;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.CodeVisitor;
import org.sonar.squidbridge.api.SourceFile;

public class AstTreeVisitorContextImpl
implements AstTreeVisitorContext {
    private final ScriptTree tree;
    private final SourceFile sourceFile;
    private final File file;

    public AstTreeVisitorContextImpl(ScriptTree tree, SourceFile sourceFile, File file) {
        this.tree = tree;
        this.sourceFile = sourceFile;
        this.file = file;
    }

    @Override
    public ScriptTree getTree() {
        return this.tree;
    }

    @Override
    public void addIssue(CodeVisitor check, Tree tree, String message) {
        this.addIssue(check, ((JavaScriptTree)tree).getLine(), message);
    }

    @Override
    public void addIssue(CodeVisitor check, int line, String message) {
        Preconditions.checkNotNull(check);
        Preconditions.checkNotNull(message);
        CheckMessage checkMessage = new CheckMessage(check, message, new Object[0]);
        if (line > 0) {
            checkMessage.setLine(line);
        }
        this.sourceFile.log(checkMessage);
    }

    @Override
    public String getFileKey() {
        return this.sourceFile.getKey();
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

