/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.declaration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.declaration.ParameterListTreeImpl;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.implementations.statement.BlockTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.AccessorMethodDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.GeneratorMethodDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.ParameterListTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.expression.LiteralTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class MethodDeclarationTreeImpl
extends JavaScriptTree
implements GeneratorMethodDeclarationTree,
AccessorMethodDeclarationTree {
    private final Tree.Kind kind;
    @Nullable
    private InternalSyntaxToken staticToken;
    @Nullable
    private final InternalSyntaxToken starToken;
    @Nullable
    private final InternalSyntaxToken accessorToken;
    private final ExpressionTree name;
    private final ParameterListTreeImpl parameters;
    private final BlockTreeImpl body;

    private MethodDeclarationTreeImpl(Tree.Kind kind, @Nullable InternalSyntaxToken starToken, @Nullable InternalSyntaxToken accessorToken, ExpressionTree name, ParameterListTreeImpl parameters, BlockTreeImpl body) {
        super(kind);
        this.kind = kind;
        this.starToken = starToken;
        this.accessorToken = accessorToken;
        this.name = name;
        this.parameters = parameters;
        this.body = body;
        if (starToken != null) {
            this.addChild(starToken);
        }
        if (accessorToken != null) {
            this.addChild(accessorToken);
        }
        this.addChild((AstNode)((Object)name));
        this.addChild(parameters);
        this.addChild(body);
    }

    public static MethodDeclarationTreeImpl newMethodOrGenerator(@Nullable InternalSyntaxToken starToken, ExpressionTree name, ParameterListTreeImpl parameters, BlockTreeImpl body) {
        return new MethodDeclarationTreeImpl(starToken == null ? Tree.Kind.METHOD : Tree.Kind.GENERATOR_METHOD, starToken, null, name, parameters, body);
    }

    public static MethodDeclarationTreeImpl newAccessor(InternalSyntaxToken accessorToken, ExpressionTree name, ParameterListTreeImpl parameters, BlockTreeImpl body) {
        return new MethodDeclarationTreeImpl("get".equals(accessorToken.text()) ? Tree.Kind.GET_METHOD : Tree.Kind.SET_METHOD, null, accessorToken, name, parameters, body);
    }

    public MethodDeclarationTreeImpl completeWithStaticToken(InternalSyntaxToken staticToken) {
        this.staticToken = staticToken;
        this.prependChildren(staticToken);
        return this;
    }

    @Override
    @Nullable
    public SyntaxToken staticToken() {
        return this.staticToken;
    }

    @Override
    public SyntaxToken starToken() {
        Preconditions.checkState(this.is(Tree.Kind.GENERATOR_METHOD));
        return this.starToken;
    }

    @Override
    public InternalSyntaxToken accessorToken() {
        Preconditions.checkState(this.is(Tree.Kind.GET_METHOD) || this.is(Tree.Kind.SET_METHOD));
        return this.accessorToken;
    }

    @Override
    public ExpressionTree name() {
        return this.name;
    }

    public String nameToString() {
        if (this.name instanceof IdentifierTree) {
            return ((IdentifierTree)this.name).name();
        }
        if (this.name.is(Tree.Kind.STRING_LITERAL)) {
            String value = ((LiteralTree)this.name).value();
            return value.substring(1, value.length() - 1);
        }
        if (this.name.is(Tree.Kind.NUMERIC_LITERAL)) {
            return ((LiteralTree)this.name).value();
        }
        return ((AstNode)((Object)this.name)).getTokenValue();
    }

    @Override
    public ParameterListTree parameters() {
        return this.parameters;
    }

    @Override
    public BlockTreeImpl body() {
        return this.body;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray(this.name, this.parameters, this.body);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMethodDeclaration(this);
    }
}

