/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.PairPropertyTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class PairPropertyTreeImpl
extends JavaScriptTree
implements PairPropertyTree {
    private final ExpressionTree key;
    private final SyntaxToken operator;
    private final ExpressionTree value;

    public PairPropertyTreeImpl(ExpressionTree key, InternalSyntaxToken operator, ExpressionTree value) {
        super(Tree.Kind.PAIR_PROPERTY);
        this.key = key;
        this.operator = operator;
        this.value = value;
        this.addChildren((AstNode)((Object)key), operator, (AstNode)((Object)value));
    }

    @Override
    public ExpressionTree key() {
        return this.key;
    }

    @Override
    @Nullable
    public SyntaxToken colonToken() {
        return this.operator;
    }

    @Override
    public ExpressionTree value() {
        return this.value;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PAIR_PROPERTY;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray(this.key, this.value);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitPairProperty(this);
    }
}

