/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.UnaryExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class PrefixExpressionTreeImpl
extends JavaScriptTree
implements UnaryExpressionTree {
    private final Tree.Kind kind;
    private final InternalSyntaxToken operator;
    private final ExpressionTree expression;

    public PrefixExpressionTreeImpl(Tree.Kind kind, InternalSyntaxToken operator, ExpressionTree expression) {
        super(kind);
        this.kind = Preconditions.checkNotNull(kind);
        this.operator = operator;
        this.expression = Preconditions.checkNotNull(expression);
        this.addChildren(operator, (AstNode)((Object)expression));
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public SyntaxToken operator() {
        return this.operator;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator(this.expression);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitUnaryExpression(this);
    }
}

