/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.statement;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.statement.SwitchClauseTree;
import org.sonar.javascript.model.interfaces.statement.SwitchStatementTree;

public class SwitchStatementTreeImpl
extends JavaScriptTree
implements SwitchStatementTree {
    private SyntaxToken switchKeyword;
    private SyntaxToken openParenthesis;
    private ExpressionTree expression;
    private SyntaxToken closeParenthesis;
    private final SyntaxToken openCurlyBrace;
    private final List<SwitchClauseTree> cases;
    private final SyntaxToken closeCurlyBrace;

    public SwitchStatementTreeImpl(InternalSyntaxToken openCurlyBrace, List<SwitchClauseTree> cases, InternalSyntaxToken closeCurlyBrace) {
        super(Tree.Kind.SWITCH_STATEMENT);
        this.openCurlyBrace = openCurlyBrace;
        this.cases = cases;
        this.closeCurlyBrace = closeCurlyBrace;
        this.addChild(openCurlyBrace);
        for (SwitchClauseTree c : cases) {
            this.addChild((AstNode)((Object)c));
        }
        this.addChild(closeCurlyBrace);
    }

    public SwitchStatementTreeImpl complete(InternalSyntaxToken switchKeyword, InternalSyntaxToken openParenthesis, ExpressionTree expression, InternalSyntaxToken closeParenthesis) {
        this.switchKeyword = switchKeyword;
        this.openParenthesis = openParenthesis;
        this.expression = expression;
        this.closeParenthesis = closeParenthesis;
        this.prependChildren(switchKeyword, openParenthesis, (AstNode)((Object)expression), closeParenthesis);
        return this;
    }

    @Override
    public SyntaxToken switchKeyword() {
        return this.switchKeyword;
    }

    @Override
    public SyntaxToken openParenthesis() {
        return this.openParenthesis;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeParenthesis() {
        return this.closeParenthesis;
    }

    @Override
    public SyntaxToken openCurlyBrace() {
        return this.openCurlyBrace;
    }

    @Override
    public List<SwitchClauseTree> cases() {
        return this.cases;
    }

    @Override
    public SyntaxToken closeCurlyBrace() {
        return this.closeCurlyBrace;
    }

    @Override
    public AstNodeType getKind() {
        return Tree.Kind.SWITCH_STATEMENT;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(Iterators.singletonIterator(this.expression), this.cases.iterator());
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitSwitchStatement(this);
    }
}

