/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.toolkit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.impl.Parser;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.colorizer.CDocTokenizer;
import org.sonar.colorizer.CppDocTokenizer;
import org.sonar.colorizer.JavadocTokenizer;
import org.sonar.colorizer.KeywordsTokenizer;
import org.sonar.colorizer.StringTokenizer;
import org.sonar.colorizer.Tokenizer;
import org.sonar.javascript.EcmaScriptConfiguration;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.parser.EcmaScriptParser;
import org.sonar.sslr.toolkit.AbstractConfigurationModel;
import org.sonar.sslr.toolkit.ConfigurationProperty;
import org.sonar.sslr.toolkit.Validators;

public class JavaScriptConfigurationModel
extends AbstractConfigurationModel {
    private static final Logger LOG = LoggerFactory.getLogger(JavaScriptConfigurationModel.class);
    private static final String CHARSET_PROPERTY_KEY = "sonar.sourceEncoding";
    @VisibleForTesting
    ConfigurationProperty charsetProperty = new ConfigurationProperty("Charset", "sonar.sourceEncoding", JavaScriptConfigurationModel.getPropertyOrDefaultValue("sonar.sourceEncoding", "UTF-8"), Validators.charsetValidator());

    @Override
    public List<ConfigurationProperty> getProperties() {
        return ImmutableList.of(this.charsetProperty);
    }

    @Override
    public Charset getCharset() {
        return Charset.forName(this.charsetProperty.getValue());
    }

    @Override
    public Parser<? extends Grammar> doGetParser() {
        return EcmaScriptParser.create(this.getConfiguration());
    }

    @Override
    public List<Tokenizer> doGetTokenizers() {
        return ImmutableList.of(new StringTokenizer("<span class=\"s\">", "</span>"), new CDocTokenizer("<span class=\"cd\">", "</span>"), new JavadocTokenizer("<span class=\"cppd\">", "</span>"), new CppDocTokenizer("<span class=\"cppd\">", "</span>"), new KeywordsTokenizer("<span class=\"k\">", "</span>", EcmaScriptKeyword.keywordValues()));
    }

    @VisibleForTesting
    EcmaScriptConfiguration getConfiguration() {
        return new EcmaScriptConfiguration(this.getCharset());
    }

    @VisibleForTesting
    static String getPropertyOrDefaultValue(String propertyKey, String defaultValue) {
        String propertyValue = System.getProperty(propertyKey);
        if (propertyValue == null) {
            LOG.info("The property \"" + propertyKey + "\" is not set, using the default value \"" + defaultValue + "\".");
            return defaultValue;
        }
        LOG.info("The property \"" + propertyKey + "\" is set, using its value \"" + propertyValue + "\".");
        return propertyValue;
    }
}

