/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.devkit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.PreprocessingDirective;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.devkit.Offsets;
import com.sonar.sslr.impl.Parser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.colorizer.HtmlOptions;
import org.sonar.colorizer.HtmlRenderer;
import org.sonar.colorizer.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SsdkGui
extends JFrame {
    private static final String CSS_PATH = "/com/sonar/sslr/devkit/codeEditor.css";
    private static final Logger LOG = LoggerFactory.getLogger("DevKit");
    private static final DefaultTreeModel EMPTY_TREE_MODEL = new DefaultTreeModel(null);
    private final JFileChooser fileChooser = new JFileChooser();
    private final JButton openButton = new JButton();
    private final JButton parseButton = new JButton();
    private final JPanel buttonPanel = new JPanel();
    private final JTree astTree = new JTree();
    private final JScrollPane astTreeScrollPane = new JScrollPane(this.astTree);
    private final Map<Object, DefaultMutableTreeNode> userObjectToTreeNodeCache = Maps.newHashMap();
    private final JEditorPane codeEditor = new JEditorPane();
    private final JScrollPane codeEditorScrollPane = new JScrollPane(this.codeEditor);
    private final JSplitPane splitPane = new JSplitPane(1, this.codeEditorScrollPane, this.astTreeScrollPane);
    private final Offsets lineOffsets = new Offsets();
    private final Parser<? extends Grammar> parser;
    private final List<Tokenizer> colorizerTokenizers;
    private final HtmlRenderer htmlRenderer = new HtmlRenderer(new HtmlOptions(false, null, false));

    public SsdkGui(Parser<? extends Grammar> parser, List<Tokenizer> colorizerTokenizers) {
        this.parser = parser;
        this.colorizerTokenizers = colorizerTokenizers;
        this.setLayout(new BorderLayout(2, 2));
        this.setDefaultCloseOperation(3);
        this.openButton.setText("Open file");
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int returnVal = SsdkGui.this.fileChooser.showOpenDialog(SsdkGui.this);
                if (returnVal == 0) {
                    File file = SsdkGui.this.fileChooser.getSelectedFile();
                    SsdkGui.this.loadFromFile(file);
                }
            }
        });
        this.parseButton.setText("Parse text");
        this.parseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String code = "";
                Document document = SsdkGui.this.codeEditor.getDocument();
                if (document.getLength() > 0) {
                    try {
                        code = document.getText(1, document.getEndPosition().getOffset() - 1);
                    }
                    catch (BadLocationException e) {
                        LOG.error("Error while reading code buffer", e);
                    }
                }
                int caretOffset = SsdkGui.this.codeEditor.getCaretPosition();
                SsdkGui.this.loadFromString(code);
                SsdkGui.this.codeEditor.setCaretPosition(caretOffset);
            }
        });
        this.buttonPanel.add(this.openButton);
        this.buttonPanel.add(this.parseButton);
        this.add((Component)this.buttonPanel, "Last");
        this.astTree.getSelectionModel().setSelectionMode(4);
        this.astTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                SsdkGui.this.highlightSelectedPaths();
                SsdkGui.this.scrollToFirstSelectedPath();
            }
        });
        this.codeEditor.setContentType("text/html");
        this.codeEditor.setEditable(true);
        this.codeEditor.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent event) {
                SsdkGui.this.showAst("");
            }
        });
        this.codeEditor.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent event) {
                SsdkGui.this.selectPath();
                SsdkGui.this.scrollToSelectedPath();
            }
        });
        this.splitPane.setDividerLocation(500);
        this.add((Component)this.splitPane, "Center");
        this.loadFromString("");
    }

    private void highlightSelectedPaths() {
        this.codeEditor.getHighlighter().removeAllHighlights();
        TreePath[] selectedPaths = this.astTree.getSelectionPaths();
        if (selectedPaths != null) {
            for (TreePath selectedPath : selectedPaths) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
                AstNode astNode = this.getAstNodeFromUserObject(treeNode.getUserObject());
                try {
                    Token firstToken = astNode.getToken();
                    Token lastToken = astNode.getLastToken();
                    this.codeEditor.getHighlighter().addHighlight(this.lineOffsets.getStartOffset(firstToken), this.lineOffsets.getEndOffset(lastToken), new DefaultHighlighter.DefaultHighlightPainter(Color.LIGHT_GRAY));
                }
                catch (BadLocationException e) {
                    LOG.error("Error with the highlighter", e);
                }
            }
        }
    }

    private void scrollToFirstSelectedPath() {
        TreePath selectedPath = this.astTree.getSelectionPath();
        if (selectedPath != null) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
            AstNode astNode = this.getAstNodeFromUserObject(treeNode.getUserObject());
            int visibleLines = this.codeEditor.getVisibleRect().height / this.codeEditor.getFontMetrics(this.codeEditor.getFont()).getHeight();
            int line = astNode.getToken().getLine() + visibleLines / 2;
            try {
                this.codeEditor.scrollRectToVisible(this.codeEditor.modelToView(0));
                this.codeEditor.scrollRectToVisible(this.codeEditor.modelToView(this.lineOffsets.getOffset(line, 0)));
            }
            catch (BadLocationException e) {
                LOG.error("Error with the scrolling", e);
            }
        }
    }

    private DefaultMutableTreeNode getParentFromUserObject(Object userObject) {
        DefaultMutableTreeNode parentTreeNode;
        DefaultMutableTreeNode treeNode = this.userObjectToTreeNodeCache.get(userObject);
        Preconditions.checkState(treeNode != null, "No tree node with the given user object was found");
        boolean isUnderTrivia = false;
        for (parentTreeNode = treeNode; !isUnderTrivia && parentTreeNode != null; parentTreeNode = (DefaultMutableTreeNode)parentTreeNode.getParent()) {
            isUnderTrivia = parentTreeNode.getUserObject() instanceof Trivia;
        }
        return parentTreeNode;
    }

    private AstNode getAstNodeFromUserObject(Object userObject) {
        Preconditions.checkNotNull(userObject, "userObject cannot be null");
        DefaultMutableTreeNode parent = this.getParentFromUserObject(userObject);
        return (AstNode)(parent == null ? userObject : parent.getUserObject());
    }

    private void selectPath() {
        if (!EMPTY_TREE_MODEL.equals(this.astTree.getModel())) {
            int offset = this.codeEditor.getCaretPosition();
            int line = this.lineOffsets.getLineFromOffset(offset);
            int column = this.lineOffsets.getColumnFromOffsetAndLine(offset, line);
            int minimumOffset = Integer.MAX_VALUE;
            DefaultMutableTreeNode treeNode = null;
            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.astTree.getModel().getRoot()).breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                AstNode astNode;
                Token token;
                DefaultMutableTreeNode treeNodeChild = (DefaultMutableTreeNode)enumeration.nextElement();
                if (this.getParentFromUserObject(treeNodeChild.getUserObject()) != null || (token = (astNode = (AstNode)treeNodeChild.getUserObject()).getToken()).getLine() <= line && (token.getLine() != line || token.getColumn() < column) || this.lineOffsets.getStartOffset(token) >= minimumOffset) continue;
                minimumOffset = this.lineOffsets.getStartOffset(token);
                treeNode = treeNodeChild;
            }
            this.astTree.clearSelection();
            if (treeNode != null) {
                this.astTree.addSelectionPath(new TreePath(treeNode.getPath()));
                this.highlightSelectedPaths();
            }
        }
    }

    private void scrollToSelectedPath() {
        TreePath selectionPath = this.astTree.getSelectionPath();
        if (selectionPath != null) {
            this.astTree.scrollPathToVisible(selectionPath);
        }
    }

    private void loadFromFile(File file) {
        try {
            this.loadFromString(FileUtils.readFileToString(file));
            this.codeEditor.setCaretPosition(0);
        }
        catch (IOException e) {
            LOG.error("Unable to load the code file '" + file.getAbsolutePath() + "'", e);
        }
    }

    private void loadFromString(String code) {
        this.showCode(code);
        this.lineOffsets.computeLineOffsets(code, this.codeEditor.getDocument().getEndPosition().getOffset());
        this.showAst(code);
    }

    private void showCode(String code) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><head><style type=\"text/css\">");
        sb.append(this.getCss());
        sb.append("</style></head><body><pre class=\"code\">");
        sb.append(this.htmlRenderer.render(new StringReader(code), this.colorizerTokenizers));
        sb.append("</pre></body></html>");
        this.codeEditor.setText(sb.toString());
    }

    private void showAst(String code) {
        if (!EMPTY_TREE_MODEL.equals(this.astTree.getModel())) {
            this.astTree.setModel(EMPTY_TREE_MODEL);
            this.userObjectToTreeNodeCache.clear();
        }
        if (code.length() > 0) {
            try {
                AstNode astNode = this.parser.parse(code);
                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(astNode);
                this.userObjectToTreeNodeCache.put(astNode, treeNode);
                this.addChildNodes(treeNode, astNode);
                this.astTree.setModel(new DefaultTreeModel(treeNode));
            }
            catch (RecognitionException re) {
                LOG.error("Unable to parse the code.", re);
            }
        }
    }

    private void addChildNodes(DefaultMutableTreeNode treeNode, AstNode astNode) {
        block3: {
            block2: {
                if (!astNode.hasChildren()) break block2;
                for (AstNode astNodeChild : astNode.getChildren()) {
                    DefaultMutableTreeNode treeNodeChild = new DefaultMutableTreeNode(astNodeChild);
                    this.userObjectToTreeNodeCache.put(astNodeChild, treeNodeChild);
                    treeNode.add(treeNodeChild);
                    this.addChildNodes(treeNodeChild, astNodeChild);
                }
                break block3;
            }
            if (!astNode.hasToken() || !astNode.getToken().hasTrivia()) break block3;
            for (Trivia trivia : astNode.getToken().getTrivia()) {
                DefaultMutableTreeNode treeNodeChild = new DefaultMutableTreeNode(trivia);
                this.userObjectToTreeNodeCache.put(trivia, treeNodeChild);
                treeNode.add(treeNodeChild);
                if (!trivia.hasPreprocessingDirective()) continue;
                PreprocessingDirective directive = trivia.getPreprocessingDirective();
                DefaultMutableTreeNode treeNodeInnerChild = new DefaultMutableTreeNode(directive.getAst());
                this.userObjectToTreeNodeCache.put(directive.getAst(), treeNodeInnerChild);
                treeNodeChild.add(treeNodeInnerChild);
                this.addChildNodes(treeNodeInnerChild, directive.getAst());
            }
        }
    }

    private Object getCss() {
        try {
            InputStream inputStream = SsdkGui.class.getResourceAsStream(CSS_PATH);
            if (inputStream == null) {
                throw new FileNotFoundException("Unable to find the resource /com/sonar/sslr/devkit/codeEditor.css");
            }
            return IOUtils.toString(inputStream);
        }
        catch (IOException e) {
            LOG.error("Unable to read the CSS file '/com/sonar/sslr/devkit/codeEditor.css'", e);
            return "";
        }
    }

    private void readObject(ObjectInputStream os) throws NotSerializableException {
        throw new NotSerializableException(this.getClass().getName());
    }

    private void writeObject(ObjectOutputStream os) throws NotSerializableException {
        throw new NotSerializableException(this.getClass().getName());
    }
}

