/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.lexer;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.lexer.LexerState;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.CodeReader;

public class IndentationChannel
extends Channel<Lexer> {
    private final StringBuilder buffer = new StringBuilder();
    private final LexerState lexerState;

    public IndentationChannel(LexerState lexerState) {
        this.lexerState = lexerState;
    }

    public boolean consume(CodeReader code, Lexer lexer) {
        if (this.lexerState.joined) {
            this.lexerState.joined = false;
            return false;
        }
        if (code.getColumnPosition() != 0) {
            return false;
        }
        int line = code.getLinePosition();
        int column = code.getColumnPosition();
        int whiteSpaceIndex = 0;
        char ch = code.charAt(whiteSpaceIndex);
        while (this.isWhiteSpace(ch)) {
            ch = code.charAt(++whiteSpaceIndex);
        }
        if (this.isBlankLine(ch)) {
            return false;
        }
        this.buffer.setLength(0);
        int indentationLevel = 0;
        for (int i = 0; i < whiteSpaceIndex; ++i) {
            char currentChar = (char)code.pop();
            this.buffer.append(currentChar);
            if (currentChar == '\t') {
                indentationLevel += this.countTabReplacer(indentationLevel);
                continue;
            }
            ++indentationLevel;
        }
        this.processIndents(lexer, line, column, indentationLevel);
        return this.buffer.length() != 0;
    }

    private int countTabReplacer(int indentationLevel) {
        return 8 - indentationLevel % 8;
    }

    private boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    private boolean isBlankLine(char ch) {
        return ch == '\n' || ch == '\r' || ch == '#' || ch == '\uffff';
    }

    private void processIndents(Lexer lexer, int line, int column, int indentationLevel) {
        if (indentationLevel > this.lexerState.indentationStack.peek()) {
            this.lexerState.indentationStack.push(indentationLevel);
            lexer.addToken(new Token[]{Token.builder().setType((TokenType)PythonTokenType.INDENT).setValueAndOriginalValue(this.buffer.toString()).setURI(lexer.getURI()).setLine(line).setColumn(column).build()});
        } else if (indentationLevel < this.lexerState.indentationStack.peek()) {
            while (indentationLevel < this.lexerState.indentationStack.peek()) {
                this.lexerState.indentationStack.pop();
                lexer.addToken(new Token[]{Token.builder().setType((TokenType)PythonTokenType.DEDENT).setValueAndOriginalValue(this.buffer.toString()).setURI(lexer.getURI()).setLine(line).setColumn(column).build()});
            }
        }
    }
}

