/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.python.PythonPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    public static int callCommand(String command, String[] environ, List<String> output) {
        PythonPlugin.LOG.debug("Calling command: '{}'", (Object)command);
        BufferedReader stdInput = null;
        Process process = null;
        int rc = -1;
        try {
            process = environ == null ? Runtime.getRuntime().exec(command) : Runtime.getRuntime().exec(command, environ);
            stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String s = null;
            while ((s = stdInput.readLine()) != null) {
                output.add(s);
            }
            process.waitFor();
            rc = process.exitValue();
        }
        catch (Exception e) {
            try {
                throw new SonarException("Error calling command '" + command + "', details: '" + e + "'");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stdInput);
                if (process != null) {
                    IOUtils.closeQuietly((InputStream)process.getInputStream());
                    IOUtils.closeQuietly((OutputStream)process.getOutputStream());
                    IOUtils.closeQuietly((InputStream)process.getErrorStream());
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)stdInput);
        if (process != null) {
            IOUtils.closeQuietly((InputStream)process.getInputStream());
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            IOUtils.closeQuietly((InputStream)process.getErrorStream());
        }
        return rc;
    }

    private Utils() {
    }
}

