/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.python.PythonPlugin;
import org.sonar.plugins.python.pylint.Issue;
import org.sonar.plugins.python.pylint.PylintConfiguration;
import org.sonar.plugins.python.pylint.PylintViolationsAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PylintSensor
implements Sensor {
    private static final String PYTHONPATH_ENVVAR = "PYTHONPATH";
    private RuleFinder ruleFinder;
    private RulesProfile profile;
    private PylintConfiguration conf;
    private String[] environment;

    public PylintSensor(RuleFinder ruleFinder, Project project, PylintConfiguration conf, RulesProfile profile) {
        this.ruleFinder = ruleFinder;
        this.conf = conf;
        this.profile = profile;
        this.environment = PylintSensor.getEnvironment(project);
    }

    public boolean shouldExecuteOnProject(Project project) {
        return "py".equals(project.getLanguageKey()) && !this.profile.getActiveRulesByRepository("Pylint").isEmpty();
    }

    public void analyse(Project project, SensorContext sensorContext) {
        for (InputFile inputFile : project.getFileSystem().mainFiles(new String[]{"py"})) {
            try {
                this.analyzeFile(inputFile, project, sensorContext);
            }
            catch (Exception e) {
                String msg = "Cannot analyse the file '" + inputFile.getFile().getAbsolutePath() + "', details: '" + e + "'";
                throw new SonarException(msg, (Throwable)e);
            }
        }
    }

    protected void analyzeFile(InputFile inputFile, Project project, SensorContext sensorContext) throws IOException {
        org.sonar.api.resources.File pyfile = org.sonar.api.resources.File.fromIOFile((File)inputFile.getFile(), (Project)project);
        String pylintConfigPath = this.conf.getPylintConfigPath(project);
        String pylintPath = this.conf.getPylintPath();
        PylintViolationsAnalyzer analyzer = new PylintViolationsAnalyzer(pylintPath, pylintConfigPath);
        List<Issue> issues = analyzer.analyze(inputFile.getFile().getPath(), this.environment);
        for (Issue issue : issues) {
            Rule rule = this.ruleFinder.findByKey("Pylint", issue.ruleId);
            if (rule != null) {
                if (rule.isEnabled().booleanValue()) {
                    Violation violation = Violation.create((Rule)rule, (Resource)pyfile);
                    violation.setLineId(Integer.valueOf(issue.line));
                    violation.setMessage(issue.descr);
                    sensorContext.saveViolation(violation);
                    continue;
                }
                PythonPlugin.LOG.debug("Pylint rule '{}' is disabled in Sonar", (Object)issue.ruleId);
                continue;
            }
            PythonPlugin.LOG.warn("Pylint rule '{}' is unknown in Sonar", (Object)issue.ruleId);
        }
    }

    protected static final String[] getEnvironment(Project project) {
        String[] environ = null;
        String pythonPathProp = (String)project.getProperty("sonar.python.path");
        if (pythonPathProp != null) {
            File projectRoot = project.getFileSystem().getBasedir();
            String[] parsedPaths = StringUtils.split((String)pythonPathProp, (String)",");
            List<String> absPaths = PylintSensor.toAbsPaths(parsedPaths, projectRoot);
            String delimiter = System.getProperty("path.separator");
            String pythonPath = StringUtils.join(absPaths, (String)delimiter);
            environ = new String[]{"PYTHONPATH=" + pythonPath};
        }
        return environ;
    }

    private static List<String> toAbsPaths(String[] pathStrings, File baseDir) {
        LinkedList<String> result = new LinkedList<String>();
        for (String pathStr : pathStrings) {
            pathStr = StringUtils.trim((String)pathStr);
            result.add(new File(baseDir, pathStr).getAbsolutePath());
        }
        return result;
    }
}

