/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.toolkit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.sonar.sslr.internal.toolkit.CssLoader;
import org.sonar.sslr.internal.toolkit.LineOffsets;
import org.sonar.sslr.internal.toolkit.ToolkitPresenter;
import org.sonar.sslr.internal.toolkit.ToolkitView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolkitViewImpl
extends JFrame
implements ToolkitView {
    private static final long serialVersionUID = 1L;
    private static final TreeModel EMPTY_TREE_MODEL = new DefaultTreeModel(null);
    public final transient ToolkitPresenter presenter;
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final JTree astTree = new JTree();
    private final JScrollPane astTreeScrollPane = new JScrollPane(this.astTree);
    private final JTextArea xmlTextArea = new JTextArea();
    private final JScrollPane xmlScrollPane = new JScrollPane(this.xmlTextArea);
    private final JTextArea consoleTextArea = new JTextArea();
    private final JScrollPane consoleScrollPane = new JScrollPane(this.consoleTextArea);
    private final JLabel sourceCodeLabel = new JLabel(" Source Code");
    private final JEditorPane sourceCodeEditorPane = new JEditorPane();
    private final JScrollPane sourceCodeEditorScrollPane = new JScrollPane(this.sourceCodeEditorPane);
    private final JButton sourceCodeOpenButton = new JButton();
    private final JButton sourceCodeParseButton = new JButton();
    private final JPanel sourceCodeButtonsPanel = new JPanel();
    private final JPanel sourceCodePanel = new JPanel(new BorderLayout(0, 2));
    private final JSplitPane splitPane = new JSplitPane(1, this.sourceCodePanel, this.tabbedPane);
    private final JPanel southPanel = new JPanel(new BorderLayout(0, 2));
    private final JLabel xpathLabel = new JLabel("  XPath query");
    private final JTextArea xpathTextArea = new JTextArea();
    private final JScrollPane xpathTextAreaScrollPane = new JScrollPane(this.xpathTextArea);
    private final JPanel xpathPanel = new JPanel(new BorderLayout(10, 2));
    private final JFileChooser fileChooser = new JFileChooser();
    private final JButton xpathButton = new JButton();
    private final JPanel xpathButtonPanel = new JPanel();
    private transient LineOffsets lineOffsets = null;
    private final transient DefaultHighlighter.DefaultHighlightPainter highlighter = new DefaultHighlighter.DefaultHighlightPainter(Color.LIGHT_GRAY);
    private boolean sourceCodeTextCursorMovedEventDisabled = false;
    private boolean astSelectionEventDisabled = false;

    public ToolkitViewImpl(ToolkitPresenter presenter) {
        Preconditions.checkNotNull(presenter);
        this.presenter = presenter;
        this.initComponents();
    }

    private void initComponents() {
        this.setSize(1000, 700);
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout(0, 5));
        this.astTree.getSelectionModel().setSelectionMode(4);
        this.astTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                if (!ToolkitViewImpl.this.astSelectionEventDisabled) {
                    ToolkitViewImpl.this.presenter.onAstSelectionChanged();
                }
            }
        });
        this.consoleTextArea.setEditable(false);
        this.tabbedPane.setTabPlacement(1);
        this.tabbedPane.add("Abstract Syntax Tree", this.astTreeScrollPane);
        this.tabbedPane.add("XML", this.xmlScrollPane);
        this.tabbedPane.add("Console", this.consoleScrollPane);
        this.sourceCodeEditorPane.setContentType("text/html");
        this.sourceCodeEditorPane.setEditable(true);
        ((DefaultCaret)this.sourceCodeEditorPane.getCaret()).setUpdatePolicy(0);
        this.sourceCodeEditorPane.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                ToolkitViewImpl.this.presenter.onSourceCodeKeyTyped();
            }
        });
        this.sourceCodeEditorPane.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                if (!ToolkitViewImpl.this.sourceCodeTextCursorMovedEventDisabled) {
                    ToolkitViewImpl.this.presenter.onSourceCodeTextCursorMoved();
                }
            }
        });
        this.sourceCodeOpenButton.setText("Open Source File");
        this.sourceCodeOpenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolkitViewImpl.this.presenter.onSourceCodeOpenButtonClick();
            }
        });
        this.sourceCodeParseButton.setText("Parse Source Code");
        this.sourceCodeParseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolkitViewImpl.this.presenter.onSourceCodeParseButtonClick();
            }
        });
        this.sourceCodeButtonsPanel.add(this.sourceCodeOpenButton);
        this.sourceCodeButtonsPanel.add(this.sourceCodeParseButton);
        this.sourceCodePanel.add((Component)this.sourceCodeLabel, "North");
        this.sourceCodePanel.add((Component)this.sourceCodeEditorScrollPane, "Center");
        this.sourceCodePanel.add((Component)this.sourceCodeButtonsPanel, "South");
        this.splitPane.setDividerLocation(this.getWidth() / 2);
        this.add((Component)this.splitPane, "Center");
        this.xpathPanel.add((Component)this.xpathLabel, "North");
        this.xpathPanel.add(Box.createHorizontalGlue(), "West");
        this.xpathTextArea.setText("//IDENTIFIER");
        this.xpathTextArea.setRows(8);
        this.xpathPanel.add((Component)this.xpathTextAreaScrollPane, "Center");
        this.xpathPanel.add(Box.createHorizontalGlue(), "East");
        this.southPanel.add((Component)this.xpathPanel, "North");
        this.xpathButton.setText("Evaluate XPath");
        this.xpathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolkitViewImpl.this.presenter.onXPathEvaluateButtonClick();
            }
        });
        this.xpathButtonPanel.add(this.xpathButton);
        this.southPanel.add((Component)this.xpathButtonPanel, "South");
        this.add((Component)this.southPanel, "South");
    }

    @Override
    public void run() {
        this.setVisible(true);
    }

    @Override
    public File pickFileToParse() {
        if (this.fileChooser.showOpenDialog(this) == 0) {
            return this.fileChooser.getSelectedFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void displayHighlightedSourceCode(String htmlHighlightedSourceCode) {
        try {
            this.sourceCodeTextCursorMovedEventDisabled = true;
            Preconditions.checkNotNull(htmlHighlightedSourceCode);
            StringBuffer sb = new StringBuffer();
            sb.append("<html><head><style type=\"text/css\">");
            sb.append(CssLoader.getCss());
            sb.append("</style></head><body><pre class=\"code\" id=\"code\">");
            sb.append(htmlHighlightedSourceCode);
            sb.append("</pre></body></html>");
            this.sourceCodeEditorPane.setText(sb.toString());
            this.lineOffsets = new LineOffsets(this.getSourceCode());
        }
        finally {
            this.sourceCodeTextCursorMovedEventDisabled = false;
        }
    }

    @Override
    public void displayAst(@Nullable AstNode astNode) {
        if (astNode == null) {
            this.astTree.setModel(EMPTY_TREE_MODEL);
        } else {
            DefaultMutableTreeNode treeNode = this.getTreeNode(astNode);
            this.astTree.setModel(new DefaultTreeModel(treeNode));
        }
    }

    private DefaultMutableTreeNode getTreeNode(AstNode astNode) {
        DefaultMutableTreeNode treeNode;
        block4: {
            block3: {
                treeNode = new DefaultMutableTreeNode(astNode);
                if (!astNode.hasChildren()) break block3;
                for (AstNode childAstNode : astNode.getChildren()) {
                    treeNode.add(this.getTreeNode(childAstNode));
                }
                break block4;
            }
            if (!astNode.hasToken() || !astNode.getToken().hasTrivia()) break block4;
            for (Trivia trivia : astNode.getToken().getTrivia()) {
                DefaultMutableTreeNode childTreeNode = new DefaultMutableTreeNode(trivia);
                if (trivia.hasPreprocessingDirective()) {
                    childTreeNode.add(this.getTreeNode(trivia.getPreprocessingDirective().getAst()));
                }
                treeNode.add(childTreeNode);
            }
        }
        return treeNode;
    }

    @Override
    public void displayXml(String xml) {
        Preconditions.checkNotNull(xml);
        this.xmlTextArea.setText(xml);
    }

    @Override
    public Point getSourceCodeScrollbarPosition() {
        int x = this.sourceCodeEditorScrollPane.getHorizontalScrollBar().getValue();
        int y = this.sourceCodeEditorScrollPane.getVerticalScrollBar().getValue();
        return new Point(x, y);
    }

    @Override
    public void scrollSourceCodeTo(final Point point) {
        Preconditions.checkNotNull(point);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolkitViewImpl.this.sourceCodeEditorScrollPane.getHorizontalScrollBar().setValue(point.x);
                ToolkitViewImpl.this.sourceCodeEditorScrollPane.getVerticalScrollBar().setValue(point.y);
            }
        });
    }

    @Override
    public String getSourceCode() {
        int startOffset = this.getCodeElementStartOffset();
        int endOffset = this.getCodeElementEndOffset();
        try {
            return this.sourceCodeEditorPane.getText(startOffset, endOffset - startOffset - 1);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private int getCodeElementStartOffset() {
        HTMLDocument htmlDocument = (HTMLDocument)this.sourceCodeEditorPane.getDocument();
        Element codeElement = htmlDocument.getElement("code");
        return codeElement.getStartOffset();
    }

    private int getCodeElementEndOffset() {
        HTMLDocument htmlDocument = (HTMLDocument)this.sourceCodeEditorPane.getDocument();
        Element codeElement = htmlDocument.getElement("code");
        return codeElement.getEndOffset();
    }

    @Override
    public String getXPath() {
        return this.xpathTextArea.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectAstNode(AstNode astNode) {
        if (astNode != null) {
            try {
                this.astSelectionEventDisabled = true;
                DefaultMutableTreeNode treeNode = this.getAstTreeNodeWithGivenUserObject((DefaultMutableTreeNode)this.astTree.getModel().getRoot(), astNode);
                this.astTree.getSelectionModel().addSelectionPath(new TreePath(treeNode.getPath()));
            }
            finally {
                this.astSelectionEventDisabled = false;
            }
        }
    }

    private DefaultMutableTreeNode getAstTreeNodeWithGivenUserObject(DefaultMutableTreeNode treeNode, Object userObject) {
        if (treeNode.getUserObject().equals(userObject)) {
            return treeNode;
        }
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode treeNodeWithUserObject = this.getAstTreeNodeWithGivenUserObject((DefaultMutableTreeNode)treeNode.getChildAt(i), userObject);
            if (treeNodeWithUserObject == null) continue;
            return treeNodeWithUserObject;
        }
        return null;
    }

    @Override
    public void highlightSourceCode(AstNode astNode) {
        Preconditions.checkNotNull(astNode);
        Token startToken = astNode.getToken();
        Token endToken = astNode.getLastToken();
        int startOffset = this.getValidDocumentOffsetFromSourceCodeOffset(this.lineOffsets.getStartOffset(startToken));
        int endOffset = this.getValidDocumentOffsetFromSourceCodeOffset(this.lineOffsets.getEndOffset(endToken));
        try {
            this.sourceCodeEditorPane.getHighlighter().addHighlight(startOffset, endOffset, this.highlighter);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private int getValidDocumentOffsetFromSourceCodeOffset(int offset) {
        offset = Math.max(offset, 0);
        offset += this.getCodeElementStartOffset();
        offset = Math.min(offset, this.getCodeElementEndOffset());
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAstSelections() {
        try {
            this.astSelectionEventDisabled = true;
            this.astTree.getSelectionModel().clearSelection();
        }
        finally {
            this.astSelectionEventDisabled = false;
        }
    }

    @Override
    public void scrollAstTo(@Nullable AstNode astNode) {
        if (astNode != null) {
            DefaultMutableTreeNode treeNode = this.getAstTreeNodeWithGivenUserObject((DefaultMutableTreeNode)this.astTree.getModel().getRoot(), astNode);
            this.astTree.scrollPathToVisible(new TreePath(treeNode.getPath()));
        }
    }

    @Override
    public void clearSourceCodeHighlights() {
        this.sourceCodeEditorPane.getHighlighter().removeAllHighlights();
    }

    @Override
    public void scrollSourceCodeTo(@Nullable AstNode astNode) {
        if (astNode != null) {
            int visibleLines = this.sourceCodeEditorPane.getVisibleRect().height / this.sourceCodeEditorPane.getFontMetrics(this.sourceCodeEditorPane.getFont()).getHeight();
            int line = astNode.getToken().getLine() + visibleLines / 2;
            try {
                this.sourceCodeEditorPane.scrollRectToVisible(this.sourceCodeEditorPane.modelToView(0));
                this.sourceCodeEditorPane.scrollRectToVisible(this.sourceCodeEditorPane.modelToView(this.lineOffsets.getOffset(line, 0)));
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void disableXPathEvaluateButton() {
        this.xpathButton.setEnabled(false);
    }

    @Override
    public void enableXPathEvaluateButton() {
        this.xpathButton.setEnabled(true);
    }

    @Override
    @Nullable
    public AstNode getAstNodeFollowingCurrentSourceCodeTextCursorPosition() {
        int currentOffset = this.sourceCodeEditorPane.getCaretPosition() - this.getCodeElementStartOffset();
        return this.getFollowingAstNode((DefaultMutableTreeNode)this.astTree.getModel().getRoot(), currentOffset);
    }

    private AstNode getFollowingAstNode(DefaultMutableTreeNode treeNode, int offset) {
        AstNode followingAstNode = null;
        if (treeNode != null) {
            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.astTree.getModel().getRoot()).breadthFirstEnumeration();
            int nearestOffsetSoFar = Integer.MAX_VALUE;
            while (enumeration.hasMoreElements()) {
                Token token;
                int tokenOffset;
                AstNode astNode;
                DefaultMutableTreeNode childTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!(childTreeNode.getUserObject() instanceof AstNode) || !(astNode = (AstNode)childTreeNode.getUserObject()).hasToken() || (tokenOffset = this.lineOffsets.getStartOffset(token = astNode.getToken())) < offset || tokenOffset >= nearestOffsetSoFar) continue;
                nearestOffsetSoFar = tokenOffset;
                followingAstNode = astNode;
            }
        }
        return followingAstNode;
    }

    @Override
    public List<AstNode> getSelectedAstNodes() {
        ArrayList<AstNode> acc = Lists.newArrayList();
        TreePath[] selectedPaths = this.astTree.getSelectionPaths();
        if (selectedPaths != null) {
            for (TreePath selectedPath : selectedPaths) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
                Object userObject = treeNode.getUserObject();
                if (!(userObject instanceof AstNode)) continue;
                AstNode astNode = (AstNode)userObject;
                acc.add(astNode);
            }
        }
        return acc;
    }

    @Override
    public void appendToConsole(String message) {
        this.consoleTextArea.append(message);
    }

    @Override
    public void setFocusOnConsoleView() {
        this.tabbedPane.setSelectedComponent(this.consoleScrollPane);
    }

    @Override
    public void setFocusOnAbstractSyntaxTreeView() {
        this.tabbedPane.setSelectedComponent(this.astTreeScrollPane);
    }

    @Override
    public void clearConsole() {
        this.consoleTextArea.setText("");
    }
}

