/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.annotations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionAnnotationLoader;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Cardinality;
import org.sonar.check.Rule;
import org.sonar.squidbridge.annotations.NoSqale;
import org.sonar.squidbridge.annotations.RuleTemplate;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleLinearRemediation;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.rules.ExternalDescriptionLoader;

public class AnnotationBasedRulesDefinition {
    private final RulesDefinition.NewRepository repository;
    private final String languageKey;
    private final ExternalDescriptionLoader externalDescriptionLoader;

    public static void load(RulesDefinition.NewRepository repository, String languageKey, Iterable<Class> ruleClasses) {
        new AnnotationBasedRulesDefinition(repository, languageKey).addRuleClasses(true, ruleClasses);
    }

    public AnnotationBasedRulesDefinition(RulesDefinition.NewRepository repository, String languageKey) {
        this.repository = repository;
        this.languageKey = languageKey;
        String externalDescriptionBasePath = String.format("/org/sonar/l10n/%s/rules/%s", languageKey, repository.key());
        this.externalDescriptionLoader = new ExternalDescriptionLoader(repository, externalDescriptionBasePath);
    }

    public void addRuleClasses(boolean failIfSqaleNotFound, Iterable<Class> ruleClasses) {
        this.addRuleClasses(failIfSqaleNotFound, true, ruleClasses);
    }

    public void addRuleClasses(boolean failIfSqaleNotFound, boolean failIfNoExplicitKey, Iterable<Class> ruleClasses) {
        new RulesDefinitionAnnotationLoader().load((RulesDefinition.NewExtendedRepository)this.repository, Iterables.toArray(ruleClasses, Class.class));
        ArrayList<RulesDefinition.NewRule> newRules = Lists.newArrayList();
        for (Class ruleClass : ruleClasses) {
            RulesDefinition.NewRule rule = this.newRule(ruleClass, failIfNoExplicitKey);
            this.externalDescriptionLoader.addHtmlDescription(rule);
            rule.setTemplate(AnnotationUtils.getAnnotation((Object)ruleClass, RuleTemplate.class) != null);
            if (!this.isSqaleAnnotated(ruleClass) && failIfSqaleNotFound) {
                throw new IllegalArgumentException("No SqaleSubCharacteristic annotation was found on " + ruleClass);
            }
            try {
                this.setupSqaleModel(rule, ruleClass);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Could not setup SQALE model on " + ruleClass, e);
            }
            newRules.add(rule);
        }
        this.setupExternalNames(newRules);
    }

    private boolean isSqaleAnnotated(Class<?> ruleClass) {
        return this.getSqaleSubCharAnnotation(ruleClass) != null || this.getNoSqaleAnnotation(ruleClass) != null;
    }

    @VisibleForTesting
    RulesDefinition.NewRule newRule(Class<?> ruleClass, boolean failIfNoExplicitKey) {
        RulesDefinition.NewRule rule;
        Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(ruleClass, Rule.class);
        if (ruleAnnotation == null) {
            throw new IllegalArgumentException("No Rule annotation was found on " + ruleClass);
        }
        String ruleKey = ruleAnnotation.key();
        if (StringUtils.isEmpty(ruleKey)) {
            if (failIfNoExplicitKey) {
                throw new IllegalArgumentException("No key is defined in Rule annotation of " + ruleClass);
            }
            ruleKey = ruleClass.getCanonicalName();
        }
        if ((rule = this.repository.rule(ruleKey)) == null) {
            throw new IllegalStateException("No rule was created for " + ruleClass + " in " + this.repository);
        }
        if (ruleAnnotation.cardinality() == Cardinality.MULTIPLE) {
            throw new IllegalArgumentException("Cardinality is not supported, use the RuleTemplate annotation instead");
        }
        return rule;
    }

    private void setupExternalNames(Collection<RulesDefinition.NewRule> rules) {
        URL resource = AnnotationBasedRulesDefinition.class.getResource("/org/sonar/l10n/" + this.languageKey + ".properties");
        if (resource == null) {
            return;
        }
        ResourceBundle bundle = ResourceBundle.getBundle("org.sonar.l10n." + this.languageKey, Locale.ENGLISH);
        for (RulesDefinition.NewRule rule : rules) {
            String baseKey = "rule." + this.repository.key() + "." + rule.key();
            String nameKey = baseKey + ".name";
            if (bundle.containsKey(nameKey)) {
                rule.setName(bundle.getString(nameKey));
            }
            for (RulesDefinition.NewParam param : rule.params()) {
                String paramDescriptionKey = baseKey + ".param." + param.key();
                if (!bundle.containsKey(paramDescriptionKey)) continue;
                param.setDescription(bundle.getString(paramDescriptionKey));
            }
        }
    }

    private void setupSqaleModel(RulesDefinition.NewRule rule, Class<?> ruleClass) {
        SqaleSubCharacteristic subChar = this.getSqaleSubCharAnnotation(ruleClass);
        if (subChar != null) {
            rule.setDebtSubCharacteristic(subChar.value());
        }
        SqaleConstantRemediation constant = (SqaleConstantRemediation)AnnotationUtils.getAnnotation(ruleClass, SqaleConstantRemediation.class);
        SqaleLinearRemediation linear = (SqaleLinearRemediation)AnnotationUtils.getAnnotation(ruleClass, SqaleLinearRemediation.class);
        SqaleLinearWithOffsetRemediation linearWithOffset = (SqaleLinearWithOffsetRemediation)AnnotationUtils.getAnnotation(ruleClass, SqaleLinearWithOffsetRemediation.class);
        HashSet<Annotation> remediations = Sets.newHashSet(constant, linear, linearWithOffset);
        if (Iterables.size(Iterables.filter(remediations, Predicates.notNull())) > 1) {
            throw new IllegalArgumentException("Found more than one SQALE remediation annotations on " + ruleClass);
        }
        if (constant != null) {
            rule.setDebtRemediationFunction(rule.debtRemediationFunctions().constantPerIssue(constant.value()));
        }
        if (linear != null) {
            rule.setDebtRemediationFunction(rule.debtRemediationFunctions().linear(linear.coeff()));
            rule.setEffortToFixDescription(linear.effortToFixDescription());
        }
        if (linearWithOffset != null) {
            rule.setDebtRemediationFunction(rule.debtRemediationFunctions().linearWithOffset(linearWithOffset.coeff(), linearWithOffset.offset()));
            rule.setEffortToFixDescription(linearWithOffset.effortToFixDescription());
        }
    }

    private SqaleSubCharacteristic getSqaleSubCharAnnotation(Class<?> ruleClass) {
        return (SqaleSubCharacteristic)AnnotationUtils.getAnnotation(ruleClass, SqaleSubCharacteristic.class);
    }

    private NoSqale getNoSqaleAnnotation(Class<?> ruleClass) {
        return (NoSqale)AnnotationUtils.getAnnotation(ruleClass, NoSqale.class);
    }
}

