/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.ZipUtils;
import org.sonar.plugins.python.ComplexityStat;
import org.sonar.plugins.python.PythonPlugin;
import org.sonar.plugins.python.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonComplexityAnalyzer {
    private static final String PYTHON = "python";
    private static final String ARGS = "all -v ";
    private static final String PYGENIE_DIR = "/org/sonar/plugins/python/pygenie/";
    private static final String PYGENIE_SCRIPT = "pygenie.py";
    private String commandTemplate;

    public PythonComplexityAnalyzer(Project project) {
        File workDir = project.getFileSystem().getSonarWorkingDirectory();
        File fallbackPath = new File(workDir, "/org/sonar/plugins/python/pygenie/pygenie.py");
        String pygeniePath = "";
        if (!fallbackPath.exists()) {
            this.extractPygenie(workDir);
            if (!fallbackPath.exists()) {
                throw new SonarException(fallbackPath.getAbsolutePath() + " cannot be found");
            }
        }
        pygeniePath = fallbackPath.getAbsolutePath();
        this.commandTemplate = "python " + pygeniePath + " " + ARGS;
    }

    public List<ComplexityStat> analyzeComplexity(String path) {
        LinkedList<String> output;
        String command = this.commandTemplate + " " + path;
        int rc = Utils.callCommand(command, null, output = new LinkedList<String>());
        if (rc != 0) {
            String errmsg = "pygenie returned an error, code: '" + rc + "'" + ", output:\n " + StringUtils.join(output, (String)"\n");
            throw new SonarException(errmsg);
        }
        return this.parseOutput(output);
    }

    protected final void extractPygenie(File targetFolder) {
        PythonPlugin.LOG.debug("Extracting pygenie to '{}'", (Object)targetFolder.getAbsolutePath());
        try {
            URL url = PythonComplexityAnalyzer.class.getResource(PYGENIE_DIR);
            File pygeniePath = new File(url.getFile());
            if (pygeniePath.exists()) {
                for (File f : FileUtils.listFiles((File)pygeniePath, null, (boolean)false)) {
                    FileUtils.copyFileToDirectory((File)f, (File)new File(targetFolder, PYGENIE_DIR));
                }
            } else {
                File packagePath = new File(StringUtils.substringBefore((String)url.getFile(), (String)"!").substring(5));
                ZipUtils.unzip((File)packagePath, (File)targetFolder, (ZipUtils.ZipEntryFilter)new PygenieOnlyFilter());
            }
        }
        catch (IOException e) {
            throw new SonarException("Cannot extract pygenie to '" + targetFolder.getAbsolutePath() + "'", (Throwable)e);
        }
    }

    private List<ComplexityStat> parseOutput(List<String> lines) {
        LinkedList<ComplexityStat> stats = new LinkedList<ComplexityStat>();
        List<String> linesWithoutHeader = lines.subList(2, lines.size());
        ComplexityStat fileStat = null;
        for (String line : linesWithoutHeader) {
            String entityType;
            String[] tokens = (line = line.trim()).split(" +");
            if (tokens.length != 3 || "C".equals(entityType = tokens[0])) continue;
            int count = Integer.parseInt(tokens[2]);
            String name = tokens[1];
            ComplexityStat stat = new ComplexityStat(name, count);
            if ("X".equals(entityType)) {
                fileStat = stat;
                continue;
            }
            stats.add(stat);
        }
        stats.add(0, fileStat);
        return stats;
    }

    static class PygenieOnlyFilter
    implements ZipUtils.ZipEntryFilter {
        PygenieOnlyFilter() {
        }

        public boolean accept(ZipEntry entry) {
            return entry.getName().startsWith(PythonComplexityAnalyzer.PYGENIE_DIR.substring(1));
        }
    }
}

