/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.java.annotation;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.java.annotation.ServerAnnotationProcessor;
import org.cometd.server.CometdServlet;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationCometdServlet
extends CometdServlet {
    private final List<Object> services = new ArrayList<Object>();
    private volatile ServerAnnotationProcessor processor;

    public void init() throws ServletException {
        super.init();
        this.processor = new ServerAnnotationProcessor((BayeuxServer)this.getBayeux());
        String servicesParam = this.getInitParameter("services");
        if (servicesParam != null && servicesParam.length() > 0) {
            for (String serviceClass : servicesParam.split(",")) {
                Object service = this.processService(this.processor, serviceClass.trim());
                this.services.add(service);
            }
        }
    }

    protected Object processService(ServerAnnotationProcessor processor, String serviceClassName) throws ServletException {
        Logger logger = this.getBayeux().getLogger();
        try {
            Object service = Loader.loadClass(((Object)((Object)this)).getClass(), (String)serviceClassName).newInstance();
            processor.process(service);
            logger.info("Processed annotated service " + service, new Object[0]);
            return service;
        }
        catch (Exception x) {
            logger.warn("Failed to create annotated service " + serviceClassName, (Throwable)x);
            throw new ServletException((Throwable)x);
        }
    }

    public void destroy() {
        for (Object service : this.services) {
            this.deprocessService(this.processor, service);
        }
        super.destroy();
    }

    protected void deprocessService(ServerAnnotationProcessor processor, Object service) {
        Logger logger = this.getBayeux().getLogger();
        processor.deprocess(service);
        logger.info("Deprocessed annotated service " + service, new Object[0]);
    }

    protected List<Object> getServices() {
        return this.services;
    }
}

