/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.common.HashMapMessage;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.LocalSessionImpl;
import org.cometd.server.ServerChannelImpl;
import org.cometd.server.transport.AbstractHttpTransport;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSessionImpl
implements ServerSession {
    private static final AtomicLong _idCount = new AtomicLong();
    private static final Logger _logger = LoggerFactory.getLogger(ServerSession.class);
    private final BayeuxServerImpl _bayeux;
    private final String _id;
    private final List<ServerSession.ServerSessionListener> _listeners = new CopyOnWriteArrayList<ServerSession.ServerSessionListener>();
    private final List<ServerSession.Extension> _extensions = new CopyOnWriteArrayList<ServerSession.Extension>();
    private final ArrayQueue<ServerMessage> _queue = new ArrayQueue(8, 16, (Object)this);
    private final LocalSessionImpl _localSession;
    private final AttributesMap _attributes = new AttributesMap();
    private final AtomicBoolean _connected = new AtomicBoolean();
    private final AtomicBoolean _disconnected = new AtomicBoolean();
    private final AtomicBoolean _handshook = new AtomicBoolean();
    private final Map<ServerChannelImpl, Boolean> _subscribedTo = new ConcurrentHashMap<ServerChannelImpl, Boolean>();
    private final LazyTask _lazyTask = new LazyTask();
    private AbstractServerTransport.Scheduler _scheduler;
    private ServerTransport _advisedTransport;
    private int _maxQueue = -1;
    private long _transientTimeout = -1L;
    private long _transientInterval = -1L;
    private long _timeout = -1L;
    private long _interval = -1L;
    private long _maxInterval = -1L;
    private long _maxServerInterval = -1L;
    private long _maxLazy = -1L;
    private boolean _metaConnectDelivery;
    private int _batch;
    private String _userAgent;
    private long _connectTimestamp = -1L;
    private long _intervalTimestamp;
    private boolean _nonLazyMessages;
    private boolean _broadcastToPublisher;

    protected ServerSessionImpl(BayeuxServerImpl bayeux) {
        this(bayeux, null, null);
    }

    protected ServerSessionImpl(BayeuxServerImpl bayeux, LocalSessionImpl localSession, String idHint) {
        this._bayeux = bayeux;
        this._localSession = localSession;
        StringBuilder id = new StringBuilder(30);
        int len = 20;
        if (idHint != null) {
            len += idHint.length() + 1;
            id.append(idHint);
            id.append('_');
        }
        int index = id.length();
        while (id.length() < len) {
            long random = this._bayeux.randomLong();
            id.append(Long.toString(random < 0L ? -random : random, 36));
        }
        id.insert(index, Long.toString(_idCount.incrementAndGet(), 36));
        this._id = id.toString();
        ServerTransport transport = this._bayeux.getCurrentTransport();
        if (transport != null) {
            this._intervalTimestamp = System.currentTimeMillis() + transport.getMaxInterval();
        }
        this._broadcastToPublisher = this._bayeux.isBroadcastToPublisher();
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public void setUserAgent(String userAgent) {
        this._userAgent = userAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sweep(long now) {
        if (this.isLocalSession()) {
            return;
        }
        boolean remove = false;
        AbstractServerTransport.Scheduler scheduler = null;
        Object object = this.getLock();
        synchronized (object) {
            if (this._intervalTimestamp == 0L) {
                if (this._maxServerInterval > 0L && now > this._connectTimestamp + this._maxServerInterval) {
                    _logger.info("Emergency sweeping session {}", (Object)this);
                    remove = true;
                }
            } else if (now > this._intervalTimestamp) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Sweeping session {}", (Object)this);
                }
                remove = true;
            }
            if (remove) {
                scheduler = this._scheduler;
            }
        }
        if (remove) {
            if (scheduler != null) {
                scheduler.cancel();
            }
            this._bayeux.removeServerSession(this, true);
        }
    }

    public Set<ServerChannel> getSubscriptions() {
        return Collections.unmodifiableSet(this._subscribedTo.keySet());
    }

    public void addExtension(ServerSession.Extension extension) {
        this._extensions.add(extension);
    }

    public void removeExtension(ServerSession.Extension extension) {
        this._extensions.remove(extension);
    }

    public List<ServerSession.Extension> getExtensions() {
        return Collections.unmodifiableList(this._extensions);
    }

    public void batch(Runnable batch) {
        this.startBatch();
        try {
            batch.run();
        }
        finally {
            this.endBatch();
        }
    }

    public void deliver(Session sender, ServerMessage.Mutable message) {
        ServerSession session = null;
        if (sender instanceof ServerSession) {
            session = (ServerSession)sender;
        } else if (sender instanceof LocalSession) {
            session = ((LocalSession)sender).getServerSession();
        }
        if (!this._bayeux.extendSend(session, this, message)) {
            return;
        }
        this.doDeliver(session, message);
    }

    public void deliver(Session sender, String channelId, Object data) {
        ServerMessage.Mutable message = this._bayeux.newMessage();
        message.setChannel(channelId);
        message.setData(data);
        this.deliver(sender, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeliver(ServerSession sender, ServerMessage.Mutable mutable) {
        boolean wakeup;
        if (sender == this && !this.isBroadcastToPublisher()) {
            return;
        }
        ServerMessage message = null;
        if (mutable.isMeta()) {
            if (this.extendSendMeta(mutable)) {
                message = mutable;
            }
        } else {
            message = this.extendSendMessage((ServerMessage)mutable);
        }
        if (message == null) {
            return;
        }
        this._bayeux.freeze((ServerMessage.Mutable)message);
        if (!this._listeners.isEmpty()) {
            for (ServerSession.ServerSessionListener listener : this._listeners) {
                if (!(listener instanceof ServerSession.MessageListener) || this.notifyOnMessage((ServerSession.MessageListener)listener, sender, message)) continue;
                return;
            }
        }
        Object object = this.getLock();
        synchronized (object) {
            if (!this._listeners.isEmpty()) {
                for (ServerSession.ServerSessionListener listener : this._listeners) {
                    int maxQueueSize;
                    if (!(listener instanceof ServerSession.MaxQueueListener) || (maxQueueSize = this._maxQueue) <= 0 || this._queue.size() <= maxQueueSize || this.notifyQueueMaxed((ServerSession.MaxQueueListener)listener, this, (Queue<ServerMessage>)this._queue, sender, message)) continue;
                    return;
                }
            }
            this.addMessage(message);
            if (!this._listeners.isEmpty()) {
                for (ServerSession.ServerSessionListener listener : this._listeners) {
                    if (!(listener instanceof ServerSession.QueueListener)) continue;
                    this.notifyQueued((ServerSession.QueueListener)listener, sender, message);
                }
            }
            wakeup = this._batch == 0;
        }
        if (wakeup) {
            if (message.isLazy()) {
                this.flushLazy(message);
            } else {
                this.flush();
            }
        }
    }

    private boolean notifyQueueMaxed(ServerSession.MaxQueueListener listener, ServerSession session, Queue<ServerMessage> queue, ServerSession sender, ServerMessage message) {
        try {
            return listener.queueMaxed(session, queue, sender, (Message)message);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking listener " + listener, x);
            return true;
        }
    }

    private boolean notifyOnMessage(ServerSession.MessageListener listener, ServerSession from, ServerMessage message) {
        try {
            return listener.onMessage((ServerSession)this, from, message);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking listener " + listener, x);
            return true;
        }
    }

    private void notifyQueued(ServerSession.QueueListener listener, ServerSession session, ServerMessage message) {
        try {
            listener.queued(session, message);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking listener " + listener, x);
        }
    }

    protected void handshake() {
        this._handshook.set(true);
        AbstractServerTransport transport = (AbstractServerTransport)this._bayeux.getCurrentTransport();
        if (transport != null) {
            this._maxQueue = transport.getOption("maxQueue", -1);
            this._maxInterval = this._interval >= 0L ? this._interval + transport.getMaxInterval() : transport.getMaxInterval();
            this._maxServerInterval = transport.getOption("maxServerInterval", -1);
            this._maxLazy = transport.getMaxLazyTimeout();
        }
    }

    protected void connected() {
        this._connected.set(true);
        this.cancelIntervalTimeout();
    }

    public void disconnect() {
        boolean connected = this._bayeux.removeServerSession(this, false);
        if (connected) {
            ServerMessage.Mutable message = this._bayeux.newMessage();
            message.setChannel("/meta/disconnect");
            message.setSuccessful(true);
            this.deliver((Session)this, message);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endBatch() {
        Object object = this.getLock();
        synchronized (object) {
            if (--this._batch == 0 && this._nonLazyMessages) {
                this.flush();
                return true;
            }
        }
        return false;
    }

    public LocalSession getLocalSession() {
        return this._localSession;
    }

    public boolean isLocalSession() {
        return this._localSession != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBatch() {
        Object object = this.getLock();
        synchronized (object) {
            ++this._batch;
        }
    }

    public void addListener(ServerSession.ServerSessionListener listener) {
        this._listeners.add(listener);
    }

    public String getId() {
        return this._id;
    }

    public Object getLock() {
        return this;
    }

    public Queue<ServerMessage> getQueue() {
        return this._queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNonLazyMessages() {
        Object object = this.getLock();
        synchronized (object) {
            return this._nonLazyMessages;
        }
    }

    private void clearQueue() {
        this._queue.clear();
        this._nonLazyMessages = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessage(ServerMessage message) {
        Object object = this.getLock();
        synchronized (object) {
            this._queue.add((Object)message);
            this._nonLazyMessages |= !message.isLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerMessage> takeQueue() {
        List<ServerMessage> copy = Collections.emptyList();
        Object object = this.getLock();
        synchronized (object) {
            int size;
            if (!this._listeners.isEmpty()) {
                for (ServerSession.ServerSessionListener listener : this._listeners) {
                    if (!(listener instanceof ServerSession.DeQueueListener)) continue;
                    this.notifyDeQueue((ServerSession.DeQueueListener)listener, this, (Queue<ServerMessage>)this._queue);
                }
            }
            if ((size = this._queue.size()) > 0) {
                copy = new ArrayList(size);
                copy.addAll((Collection<ServerMessage>)this._queue);
            }
            this.clearQueue();
        }
        return copy;
    }

    private void notifyDeQueue(ServerSession.DeQueueListener listener, ServerSession serverSession, Queue<ServerMessage> queue) {
        try {
            listener.deQueue(serverSession, queue);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking listener " + listener, x);
        }
    }

    public void removeListener(ServerSession.ServerSessionListener listener) {
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduler(AbstractServerTransport.Scheduler newScheduler) {
        if (newScheduler == null) {
            AbstractServerTransport.Scheduler oldScheduler;
            Object object = this.getLock();
            synchronized (object) {
                oldScheduler = this._scheduler;
                if (oldScheduler != null) {
                    this._scheduler = null;
                }
            }
            if (oldScheduler != null) {
                oldScheduler.cancel();
            }
        } else {
            AbstractServerTransport.Scheduler oldScheduler;
            boolean schedule = false;
            Object object = this.getLock();
            synchronized (object) {
                oldScheduler = this._scheduler;
                this._scheduler = newScheduler;
                if (this.hasNonLazyMessages() && this._batch == 0) {
                    schedule = true;
                    if (newScheduler instanceof AbstractHttpTransport.HttpScheduler) {
                        this._scheduler = null;
                    }
                }
            }
            if (oldScheduler != null && oldScheduler != newScheduler) {
                oldScheduler.cancel();
            }
            if (schedule) {
                newScheduler.schedule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        AbstractServerTransport.Scheduler scheduler;
        Iterator<ServerMessage> iterator = this.getLock();
        synchronized (iterator) {
            this._lazyTask.cancel();
            scheduler = this._scheduler;
            if (scheduler != null && scheduler instanceof AbstractHttpTransport.HttpScheduler) {
                this._scheduler = null;
            }
        }
        if (scheduler != null) {
            scheduler.schedule();
            return;
        }
        if (this._localSession != null && this.hasNonLazyMessages()) {
            for (ServerMessage msg : this.takeQueue()) {
                this._localSession.receive((Message.Mutable)new HashMapMessage((Message)msg));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushLazy(ServerMessage message) {
        Object object = this.getLock();
        synchronized (object) {
            ServerChannel channel = this._bayeux.getChannel(message.getChannel());
            long lazyTimeout = -1L;
            if (channel != null) {
                lazyTimeout = channel.getLazyTimeout();
            }
            if (lazyTimeout <= 0L) {
                lazyTimeout = this._maxLazy;
            }
            if (lazyTimeout <= 0L) {
                this.flush();
            } else {
                this._lazyTask.schedule(lazyTimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSchedule() {
        AbstractServerTransport.Scheduler scheduler;
        Object object = this.getLock();
        synchronized (object) {
            scheduler = this._scheduler;
            if (scheduler != null) {
                this._scheduler = null;
            }
        }
        if (scheduler != null) {
            scheduler.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelIntervalTimeout() {
        long now = System.currentTimeMillis();
        Object object = this.getLock();
        synchronized (object) {
            this._connectTimestamp = now;
            this._intervalTimestamp = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startIntervalTimeout(long defaultInterval) {
        long interval = this.calculateInterval(defaultInterval);
        long now = System.currentTimeMillis();
        Object object = this.getLock();
        synchronized (object) {
            this._intervalTimestamp = now + interval + this._maxInterval;
        }
    }

    protected long getMaxInterval() {
        return this._maxInterval;
    }

    long getIntervalTimestamp() {
        return this._intervalTimestamp;
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this._attributes.getAttributeNameSet();
    }

    public Object removeAttribute(String name) {
        Object old = this.getAttribute(name);
        this._attributes.removeAttribute(name);
        return old;
    }

    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    public boolean isHandshook() {
        return this._handshook.get();
    }

    public boolean isConnected() {
        return this._connected.get();
    }

    public boolean isDisconnected() {
        return this._disconnected.get();
    }

    protected boolean extendRecv(ServerMessage.Mutable message) {
        if (!this._extensions.isEmpty()) {
            for (ServerSession.Extension extension : this._extensions) {
                boolean proceed = message.isMeta() ? this.notifyRcvMeta(extension, message) : this.notifyRcv(extension, message);
                if (proceed) continue;
                return false;
            }
        }
        return true;
    }

    private boolean notifyRcvMeta(ServerSession.Extension extension, ServerMessage.Mutable message) {
        try {
            return extension.rcvMeta((ServerSession)this, message);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking extension " + extension, x);
            return true;
        }
    }

    private boolean notifyRcv(ServerSession.Extension extension, ServerMessage.Mutable message) {
        try {
            return extension.rcv((ServerSession)this, message);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking extension " + extension, x);
            return true;
        }
    }

    protected boolean extendSendMeta(ServerMessage.Mutable message) {
        if (!message.isMeta()) {
            throw new IllegalStateException();
        }
        if (!this._extensions.isEmpty()) {
            for (ServerSession.Extension extension : this._extensions) {
                if (this.notifySendMeta(extension, message)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean notifySendMeta(ServerSession.Extension extension, ServerMessage.Mutable message) {
        try {
            return extension.sendMeta((ServerSession)this, message);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking extension " + extension, x);
            return true;
        }
    }

    protected ServerMessage extendSendMessage(ServerMessage message) {
        if (message.isMeta()) {
            throw new IllegalStateException();
        }
        if (!this._extensions.isEmpty()) {
            for (ServerSession.Extension extension : this._extensions) {
                message = this.notifySend(extension, message);
                if (message != null) continue;
                return null;
            }
        }
        return message;
    }

    private ServerMessage notifySend(ServerSession.Extension extension, ServerMessage message) {
        try {
            return extension.send((ServerSession)this, message);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking extension " + extension, x);
            return message;
        }
    }

    public void reAdvise() {
        this._advisedTransport = null;
    }

    public Map<String, Object> takeAdvice(ServerTransport transport) {
        if (transport != null && transport != this._advisedTransport) {
            this._advisedTransport = transport;
            long timeout = this.getTimeout() < 0L ? transport.getTimeout() : this.getTimeout();
            long interval = this.calculateInterval(transport.getInterval());
            HashMap<String, Object> advice = new HashMap<String, Object>(3);
            advice.put("reconnect", "retry");
            advice.put("interval", interval);
            advice.put("timeout", timeout);
            return advice;
        }
        return null;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public long getInterval() {
        return this._interval;
    }

    public void setTimeout(long timeoutMS) {
        this._timeout = timeoutMS;
        this._advisedTransport = null;
    }

    public void setInterval(long intervalMS) {
        this._interval = intervalMS;
        this._advisedTransport = null;
    }

    public boolean isBroadcastToPublisher() {
        return this._broadcastToPublisher;
    }

    public void setBroadcastToPublisher(boolean value) {
        this._broadcastToPublisher = value;
    }

    protected boolean removed(boolean timedOut) {
        if (!timedOut) {
            this._disconnected.set(true);
        }
        boolean connected = this._connected.getAndSet(false);
        boolean handshook = this._handshook.getAndSet(false);
        if (connected || handshook) {
            for (ServerChannelImpl channel : this._subscribedTo.keySet()) {
                channel.unsubscribe(this);
            }
            for (ServerSession.ServerSessionListener listener : this._listeners) {
                if (!(listener instanceof ServerSession.RemoveListener)) continue;
                this.notifyRemoved((ServerSession.RemoveListener)listener, this, timedOut);
            }
        }
        return connected;
    }

    private void notifyRemoved(ServerSession.RemoveListener listener, ServerSession serverSession, boolean timedout) {
        try {
            listener.removed(serverSession, timedout);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking listener " + listener, x);
        }
    }

    public void setMetaConnectDeliveryOnly(boolean meta) {
        this._metaConnectDelivery = meta;
    }

    public boolean isMetaConnectDeliveryOnly() {
        return this._metaConnectDelivery;
    }

    protected void subscribedTo(ServerChannelImpl channel) {
        this._subscribedTo.put(channel, Boolean.TRUE);
    }

    protected void unsubscribedFrom(ServerChannelImpl channel) {
        this._subscribedTo.remove(channel);
    }

    protected void dump(StringBuilder b, String indent) {
        b.append(this.toString());
        b.append('\n');
        for (ServerSession.ServerSessionListener child : this._listeners) {
            b.append(indent);
            b.append(" +-");
            b.append(child);
            b.append('\n');
        }
        if (this.isLocalSession()) {
            b.append(indent);
            b.append(" +-");
            this._localSession.dump(b, indent + "   ");
        }
    }

    public String toString() {
        return String.format("%s - last connect %d ms ago", this._id, System.currentTimeMillis() - this._connectTimestamp);
    }

    public long calculateTimeout(long defaultTimeout) {
        if (this._transientTimeout >= 0L) {
            return this._transientTimeout;
        }
        if (this._timeout >= 0L) {
            return this._timeout;
        }
        return defaultTimeout;
    }

    public long calculateInterval(long defaultInterval) {
        if (this._transientInterval >= 0L) {
            return this._transientInterval;
        }
        if (this._interval >= 0L) {
            return this._interval;
        }
        return defaultInterval;
    }

    public void updateTransientTimeout(long timeout) {
        this._transientTimeout = timeout;
    }

    public void updateTransientInterval(long interval) {
        this._transientInterval = interval;
    }

    private class LazyTask
    implements Runnable {
        private long _execution;
        private volatile Scheduler.Task _task;

        private LazyTask() {
        }

        @Override
        public void run() {
            ServerSessionImpl.this.flush();
            this._execution = 0L;
            this._task = null;
        }

        public boolean cancel() {
            Scheduler.Task task = this._task;
            return task != null && task.cancel();
        }

        public boolean schedule(long lazyTimeout) {
            long execution = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(lazyTimeout);
            if (this._task == null || execution < this._execution) {
                this.cancel();
                this._execution = execution;
                this._task = ServerSessionImpl.this._bayeux.schedule(this, lazyTimeout);
                return true;
            }
            return false;
        }
    }
}

