/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller;

import org.evomaster.clientJava.controller.EmbeddedSutController;
import org.evomaster.clientJava.controller.ExternalSutController;
import org.evomaster.clientJava.controller.internal.SutController;
import org.evomaster.clientJava.instrumentation.InstrumentingAgent;
import shaded.com.ea.agentloader.AgentLoader;

public class InstrumentedSutStarter {
    private final SutController sutController;

    public InstrumentedSutStarter(SutController sutController) {
        this.sutController = sutController;
        if (sutController instanceof EmbeddedSutController) {
            InstrumentingAgent.changePackagesToInstrument(sutController.getPackagePrefixesToCover());
        } else if (sutController instanceof ExternalSutController) {
            ((ExternalSutController)sutController).setInstrumentation(true);
            System.setProperty("shaded.org.eclipse.jetty.util.log.class", "shaded.org.eclipse.jetty.util.log.StdErrLog");
            System.setProperty("shaded.org.eclipse.jetty.LEVEL", "OFF");
        } else {
            throw new IllegalArgumentException("Invalid SUT controller type");
        }
    }

    public boolean start() {
        return this.sutController.startTheControllerServer();
    }

    public boolean stop() {
        return this.sutController.stopTheControllerServer();
    }

    public int getControllerServerPort() {
        return this.sutController.getControllerServerPort();
    }

    static {
        AgentLoader.loadAgentClass(InstrumentingAgent.class.getName(), "foobar_packagenameshouldnotexist.");
    }
}

