/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller.db;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.evomaster.clientJava.controller.db.QueryResult;

public class SqlScriptRunner {
    private static final String DEFAULT_DELIMITER = ";";
    public static final Pattern delimP = Pattern.compile("^\\s*(--)?\\s*delimiter\\s*=?\\s*([^\\s]+)+\\s*.*$", 2);
    private final Connection connection;
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;

    public SqlScriptRunner(Connection connection) {
        this.connection = connection;
    }

    public void setDelimiter(String delimiter, boolean fullLineDelimiter) {
        this.delimiter = delimiter;
        this.fullLineDelimiter = fullLineDelimiter;
    }

    public void runScript(Reader reader) {
        Objects.requireNonNull(reader);
        SqlScriptRunner.runCommands(this.connection, this.readCommands(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runCommands(Connection connection, List<String> commands) {
        try {
            boolean originalAutoCommit = connection.getAutoCommit();
            try {
                if (!originalAutoCommit) {
                    connection.setAutoCommit(true);
                }
                for (String command : commands) {
                    SqlScriptRunner.execCommand(connection, command);
                }
            }
            finally {
                connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e, e);
        }
    }

    public List<String> readCommands(Reader reader) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer command = null;
        try {
            String line;
            LineNumberReader lineReader = new LineNumberReader(reader);
            while ((line = lineReader.readLine()) != null) {
                if (command == null) {
                    command = new StringBuffer();
                }
                String trimmedLine = line.trim();
                Matcher delimMatch = delimP.matcher(trimmedLine);
                if (trimmedLine.isEmpty() || trimmedLine.startsWith("//") || trimmedLine.startsWith("--")) continue;
                if (delimMatch.matches()) {
                    this.setDelimiter(delimMatch.group(2), false);
                    continue;
                }
                if (!this.fullLineDelimiter && trimmedLine.endsWith(this.delimiter) || this.fullLineDelimiter && trimmedLine.equals(this.delimiter)) {
                    command.append(line.substring(0, line.lastIndexOf(this.delimiter)));
                    command.append(" ");
                    list.add(command.toString());
                    command = null;
                    continue;
                }
                command.append(line);
                command.append("\n");
            }
            if (command != null) {
                list.add(command.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public static QueryResult execCommand(Connection conn, String command) throws SQLException {
        Statement statement = conn.createStatement();
        try {
            statement.execute(command);
        }
        catch (SQLException e) {
            String errText = String.format("Error executing '%s': %s", command, e.getMessage());
            throw new SQLException(errText, e);
        }
        conn.commit();
        ResultSet result = statement.getResultSet();
        QueryResult queryResult = new QueryResult(result);
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return queryResult;
    }
}

