/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.instrumentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.evomaster.clientJava.instrumentation.TargetInfo;
import org.evomaster.clientJava.instrumentation.staticState.ExecutionTracer;
import org.evomaster.clientJava.instrumentation.staticState.ObjectiveRecorder;

public class InstrumentationController {
    public static void resetForNewSearch() {
        ExecutionTracer.reset();
        ObjectiveRecorder.reset();
    }

    public static void resetForNewTest() {
        ExecutionTracer.reset();
        ObjectiveRecorder.clearFirstTimeEncountered();
    }

    public static List<TargetInfo> getTargetInfos(Collection<Integer> ids) {
        ArrayList<TargetInfo> list = new ArrayList<TargetInfo>();
        Map<String, Double> objectives = ExecutionTracer.getInternalReferenceToObjectiveCoverage();
        ids.stream().forEach(id -> {
            String descriptiveId = ObjectiveRecorder.getDescriptiveId(id);
            double val = objectives.getOrDefault(descriptiveId, 0.0);
            TargetInfo info = new TargetInfo((Integer)id, null, val);
            list.add(info);
        });
        ObjectiveRecorder.getTargetsSeenFirstTime().stream().forEach(s -> {
            double val = (Double)objectives.get(s);
            int mappedId = ObjectiveRecorder.getMappedId(s);
            TargetInfo info = new TargetInfo(mappedId, (String)s, val);
            list.add(info);
        });
        return list;
    }
}

