/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.instrumentation;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import org.evomaster.clientJava.clientUtil.SimpleLogger;
import org.evomaster.clientJava.instrumentation.ClassName;
import org.evomaster.clientJava.instrumentation.ClassesToExclude;
import org.evomaster.clientJava.instrumentation.Instrumentator;
import org.evomaster.clientJava.instrumentation.external.AgentController;
import shaded.org.objectweb.asm.ClassReader;

public class InstrumentingAgent {
    public static final String EXTERNAL_PORT_PROP = "evomaster.javaagent.external.port";
    private static Instrumentator instrumentator;
    private static boolean active;

    public static void premain(String args, Instrumentation inst) {
        InstrumentingAgent.agentmain(args, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        instrumentator = new Instrumentator(agentArgs);
        inst.addTransformer(new TransformerForTests());
        active = true;
        String port = System.getProperty(EXTERNAL_PORT_PROP);
        if (port != null) {
            SimpleLogger.info("Starting remote instrumenting Agent for packages: " + agentArgs);
            AgentController.start(Integer.parseInt(port));
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static void changePackagesToInstrument(String packagePrefixesToCover) {
        instrumentator = new Instrumentator(packagePrefixesToCover);
    }

    static {
        active = false;
    }

    private static class TransformerForTests
    implements ClassFileTransformer {
        private TransformerForTests() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (!ClassesToExclude.checkIfCanInstrument(ClassName.get(className))) {
                return classfileBuffer;
            }
            ClassReader reader = new ClassReader(classfileBuffer);
            return instrumentator.transformBytes(loader, ClassName.get(className), reader);
        }
    }
}

