/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.instrumentation.staticState;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.evomaster.clientJava.instrumentation.ClassName;
import org.evomaster.clientJava.instrumentation.heuristic.HeuristicsForJumps;
import org.evomaster.clientJava.instrumentation.heuristic.Truthness;
import org.evomaster.clientJava.instrumentation.staticState.ObjectiveRecorder;

public class ExecutionTracer {
    public static final String LINE = "Line";
    public static final String BRANCH = "Branch";
    public static final String TRUE_BRANCH = "_trueBranch";
    public static final String FALSE_BRANCH = "_falseBranch";
    private static final Map<String, Double> objectiveCoverage = new ConcurrentHashMap<String, Double>(65536);
    public static final String EXECUTED_LINE_METHOD_NAME = "executedLine";
    public static final String EXECUTED_LINE_DESCRIPTOR = "(Ljava/lang/String;I)V";
    public static final String EXECUTING_BRANCH_JUMP_METHOD_NAME = "executingBranchJump";
    public static final String JUMP_DESC_1_VALUE = "(IILjava/lang/String;II)V";
    public static final String JUMP_DESC_2_VALUES = "(IIILjava/lang/String;II)V";
    public static final String JUMP_DESC_OBJECTS = "(Ljava/lang/Object;Ljava/lang/Object;ILjava/lang/String;II)V";
    public static final String JUMP_DESC_NULL = "(Ljava/lang/Object;ILjava/lang/String;II)V";

    public static void reset() {
        objectiveCoverage.clear();
    }

    public static Map<String, Double> getInternalReferenceToObjectiveCoverage() {
        return objectiveCoverage;
    }

    public static int getNumberOfObjectives() {
        return objectiveCoverage.size();
    }

    public static int getNumberOfObjectives(String prefix) {
        return (int)objectiveCoverage.entrySet().stream().filter(e -> prefix == null || ((String)e.getKey()).startsWith(prefix)).count();
    }

    public static int getNumberOfNonCoveredObjectives(String prefix) {
        return ExecutionTracer.getNonCoveredObjectives(prefix).size();
    }

    public static Set<String> getNonCoveredObjectives(String prefix) {
        return objectiveCoverage.entrySet().stream().filter(e -> prefix == null || ((String)e.getKey()).startsWith(prefix)).filter(e -> (Double)e.getValue() < 1.0).map(e -> (String)e.getKey()).collect(Collectors.toSet());
    }

    public static Double getValue(String id) {
        return objectiveCoverage.get(id);
    }

    private static void updateObjective(String id, double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Invalid value " + value + " out of range [0,1]");
        }
        if (objectiveCoverage.containsKey(id)) {
            double previous = objectiveCoverage.get(id);
            objectiveCoverage.put(id, Math.max(value, previous));
        } else {
            objectiveCoverage.put(id, value);
        }
        ObjectiveRecorder.update(id, value);
    }

    public static void executedLine(String className, int line) {
        String id = "Line_at_" + ClassName.get(className).getFullNameWithDots() + "_" + ExecutionTracer.padNumber(line);
        ExecutionTracer.updateObjective(id, 1.0);
    }

    private static void updateBranch(String id, Truthness t) {
        ExecutionTracer.updateObjective(id + FALSE_BRANCH, t.getOfTrue());
        ExecutionTracer.updateObjective(id + TRUE_BRANCH, t.getOfFalse());
    }

    private static String getUniqueBranchId(String className, int line, int branchId) {
        return "Branch_at_" + ClassName.get(className).getFullNameWithDots() + "_at_line_" + ExecutionTracer.padNumber(line) + "_position_" + branchId;
    }

    private static String padNumber(int val) {
        if (val < 0) {
            throw new IllegalArgumentException("Negative number to pad");
        }
        if (val < 10) {
            return "0000" + val;
        }
        if (val < 100) {
            return "000" + val;
        }
        if (val < 1000) {
            return "00" + val;
        }
        if (val < 10000) {
            return "0" + val;
        }
        return "" + val;
    }

    public static void executingBranchJump(int value, int opcode, String className, int line, int branchId) {
        String id = ExecutionTracer.getUniqueBranchId(className, line, branchId);
        Truthness t = HeuristicsForJumps.getForSingleValueJump(value, opcode);
        ExecutionTracer.updateBranch(id, t);
    }

    public static void executingBranchJump(int firstValue, int secondValue, int opcode, String className, int line, int branchId) {
        String id = ExecutionTracer.getUniqueBranchId(className, line, branchId);
        Truthness t = HeuristicsForJumps.getForValueComparison(firstValue, secondValue, opcode);
        ExecutionTracer.updateBranch(id, t);
    }

    public static void executingBranchJump(Object first, Object second, int opcode, String className, int line, int branchId) {
        String id = ExecutionTracer.getUniqueBranchId(className, line, branchId);
        Truthness t = HeuristicsForJumps.getForObjectComparison(first, second, opcode);
        ExecutionTracer.updateBranch(id, t);
    }

    public static void executingBranchJump(Object obj, int opcode, String className, int line, int branchId) {
        String id = ExecutionTracer.getUniqueBranchId(className, line, branchId);
        Truthness t = HeuristicsForJumps.getForNullComparison(obj, opcode);
        ExecutionTracer.updateBranch(id, t);
    }
}

