/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.instrumentation.staticState;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ObjectiveRecorder {
    private static final Map<Integer, Double> maxObjectiveCoverage = new ConcurrentHashMap<Integer, Double>(65536);
    private static Map<String, Integer> idMapping = new ConcurrentHashMap<String, Integer>(65536);
    private static Map<Integer, String> reversedIdMapping = new ConcurrentHashMap<Integer, String>(65536);
    private static final AtomicInteger idMappingCounter = new AtomicInteger(0);
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final Queue<String> firstTimeEncountered = new ConcurrentLinkedQueue<String>();

    public static void reset() {
        maxObjectiveCoverage.clear();
        idMapping.clear();
        reversedIdMapping.clear();
        idMappingCounter.set(0);
        firstTimeEncountered.clear();
        counter.set(0);
    }

    public static List<String> getTargetsSeenFirstTime() {
        return Collections.unmodifiableList(new ArrayList<String>(firstTimeEncountered));
    }

    public static void clearFirstTimeEncountered() {
        firstTimeEncountered.clear();
    }

    public static int getAUniqueId() {
        return counter.getAndIncrement();
    }

    public static void update(String descriptiveId, double value) {
        Objects.requireNonNull(descriptiveId);
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Invalid value " + value + " out of range [0,1]");
        }
        int id = ObjectiveRecorder.getMappedId(descriptiveId);
        if (!maxObjectiveCoverage.containsKey(id)) {
            firstTimeEncountered.add(descriptiveId);
            maxObjectiveCoverage.put(id, value);
        } else {
            double old = maxObjectiveCoverage.get(id);
            if (value > old) {
                maxObjectiveCoverage.put(id, value);
            }
        }
    }

    public static int getMappedId(String descriptiveId) {
        int id = idMapping.computeIfAbsent(descriptiveId, k -> idMappingCounter.getAndIncrement());
        reversedIdMapping.computeIfAbsent(id, k -> descriptiveId);
        return id;
    }

    public static Map<Integer, String> getDescriptiveIds(Collection<Integer> ids) {
        HashMap<Integer, String> map = new HashMap<Integer, String>(ids.size());
        for (Integer id : ids) {
            map.put(id, ObjectiveRecorder.getDescriptiveId(id));
        }
        return map;
    }

    public static String getDescriptiveId(int id) {
        String descriptiveId = reversedIdMapping.get(id);
        if (descriptiveId == null) {
            throw new IllegalArgumentException("Id '" + id + "' is not mapped");
        }
        return descriptiveId;
    }
}

