/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.server.internal.inject;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import shaded.org.glassfish.hk2.api.Factory;
import shaded.org.glassfish.hk2.api.ServiceLocator;
import shaded.org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import shaded.org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import shaded.org.glassfish.jersey.server.model.Parameter;
import shaded.org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

public abstract class AbstractValueFactoryProvider
implements ValueFactoryProvider {
    private final MultivaluedParameterExtractorProvider mpep;
    private final ServiceLocator locator;
    private final Set<Parameter.Source> compatibleSources;

    protected AbstractValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator locator, Parameter.Source ... compatibleSources) {
        this.mpep = mpep;
        this.locator = locator;
        this.compatibleSources = new HashSet<Parameter.Source>(Arrays.asList(compatibleSources));
    }

    protected final MultivaluedParameterExtractor<?> getWithoutDefaultValue(Parameter parameter) {
        return this.mpep.getWithoutDefaultValue(parameter);
    }

    protected final MultivaluedParameterExtractor<?> get(Parameter parameter) {
        return this.mpep.get(parameter);
    }

    protected abstract Factory<?> createValueFactory(Parameter var1);

    @Override
    public final Factory<?> getValueFactory(Parameter parameter) {
        if (!this.compatibleSources.contains((Object)parameter.getSource())) {
            return null;
        }
        Factory<?> valueFactory = this.createValueFactory(parameter);
        if (valueFactory != null) {
            this.locator.inject(valueFactory);
        }
        return valueFactory;
    }

    @Override
    public ValueFactoryProvider.PriorityType getPriority() {
        return ValueFactoryProvider.Priority.NORMAL;
    }

    protected final ServiceLocator getLocator() {
        return this.locator;
    }
}

