/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller.db.dsl;

import java.util.ArrayList;
import java.util.List;
import org.evomaster.clientJava.controller.db.dsl.SequenceDsl;
import org.evomaster.clientJava.controller.db.dsl.StatementDsl;
import org.evomaster.clientJava.controllerApi.dto.database.operations.InsertionDto;
import org.evomaster.clientJava.controllerApi.dto.database.operations.InsertionEntryDto;

public class SqlDsl
implements SequenceDsl,
StatementDsl {
    private List<InsertionDto> list = new ArrayList<InsertionDto>();

    private SqlDsl() {
    }

    public static SequenceDsl sql() {
        return new SqlDsl();
    }

    @Override
    public StatementDsl insertInto(String tableName, Long id) {
        this.checkDsl();
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("Unspecified table");
        }
        if (id != null && this.list.stream().anyMatch(t -> id.equals(t.id))) {
            throw new IllegalArgumentException("Non-unique id: " + id);
        }
        InsertionDto dto = new InsertionDto();
        dto.targetTable = tableName;
        dto.id = id;
        this.list.add(dto);
        return this;
    }

    @Override
    public StatementDsl d(String columnName, String printableValue) {
        this.checkDsl();
        if (columnName == null || columnName.isEmpty()) {
            throw new IllegalArgumentException("Unspecified variable");
        }
        InsertionEntryDto entry = new InsertionEntryDto();
        entry.variableName = columnName;
        entry.printableValue = printableValue;
        this.current().data.add(entry);
        return this;
    }

    @Override
    public StatementDsl r(String columnName, long insertionId, boolean keepAutoGeneratedValue) {
        this.checkDsl();
        if (columnName == null || columnName.isEmpty()) {
            throw new IllegalArgumentException("Unspecified variable");
        }
        if (this.list.stream().noneMatch(t -> t.id != null && t.id.equals(insertionId))) {
            throw new IllegalArgumentException("Non-existing previous insertion with id: " + insertionId);
        }
        InsertionEntryDto entry = new InsertionEntryDto();
        entry.variableName = columnName;
        entry.foreignKeyToPreviouslyGeneratedRow = insertionId;
        entry.keepAutoGeneratedValue = keepAutoGeneratedValue;
        this.current().data.add(entry);
        return this;
    }

    @Override
    public StatementDsl r(String columnName, long insertionId) {
        return this.r(columnName, insertionId, false);
    }

    @Override
    public SequenceDsl and() {
        return this;
    }

    @Override
    public List<InsertionDto> dtos() {
        List<InsertionDto> tmp = this.list;
        this.list = null;
        return tmp;
    }

    private InsertionDto current() {
        return this.list.get(this.list.size() - 1);
    }

    private void checkDsl() {
        if (this.list == null) {
            throw new IllegalStateException("DTO was already built for this object");
        }
    }
}

