/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller.internal.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.evomaster.clientJava.clientUtil.SimpleLogger;
import org.evomaster.clientJava.controller.db.QueryResult;
import org.evomaster.clientJava.controller.db.SqlScriptRunner;
import org.evomaster.clientJava.controller.internal.db.SelectHeuristics;
import shaded.net.sf.jsqlparser.JSQLParserException;
import shaded.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import shaded.net.sf.jsqlparser.parser.TokenMgrError;

public class SqlHandler {
    private final List<String> buffer = new CopyOnWriteArrayList<String>();
    private final List<Double> distances = new ArrayList<Double>();
    private final Map<String, Set<String>> readData = new ConcurrentHashMap<String, Set<String>>();
    private final Set<String> emptySqlSelects = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile Connection connection;

    public void reset() {
        this.buffer.clear();
        this.distances.clear();
        this.readData.clear();
        this.emptySqlSelects.clear();
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void handle(String sql) {
        Objects.requireNonNull(sql);
        this.buffer.add(sql);
        this.handleReadData(sql);
    }

    private void handleReadData(String sql) {
        if (!this.isSelect(sql)) {
            return;
        }
        Map<String, Set<String>> current = SelectHeuristics.getReadDataFields(sql);
        for (Map.Entry<String, Set<String>> e : current.entrySet()) {
            String key = e.getKey();
            Set<String> values = e.getValue();
            Set<String> existing = this.readData.get(key);
            if (existing != null && existing.contains("*")) continue;
            if (existing == null) {
                existing = new HashSet<String>(values);
                this.readData.put(key, existing);
            } else {
                existing.addAll(values);
            }
            if (existing.size() <= 1 || !existing.contains("*")) continue;
            existing.clear();
            existing.add("*");
        }
    }

    public Map<String, Set<String>> getReadData() {
        return this.readData;
    }

    public Set<String> getEmptySqlSelects() {
        return this.emptySqlSelects;
    }

    public List<Double> getDistances() {
        if (this.connection == null) {
            return this.distances;
        }
        this.buffer.stream().filter(sql -> this.isSelect((String)sql)).forEach(sql -> {
            double dist = this.computeDistance((String)sql);
            this.distances.add(dist);
        });
        this.buffer.clear();
        return this.distances;
    }

    private boolean isSelect(String sql) {
        return sql.trim().toLowerCase().startsWith("select");
    }

    public static boolean isValidSql(String sql) {
        try {
            CCJSqlParserUtil.parse(sql);
            return true;
        }
        catch (JSQLParserException e) {
            return false;
        }
    }

    public Double computeDistance(String select) {
        QueryResult data;
        if (this.connection == null) {
            throw new IllegalStateException("Trying to calculate SQL distance with no DB connection");
        }
        try {
            CCJSqlParserUtil.parse(select);
        }
        catch (Exception | TokenMgrError e) {
            SimpleLogger.uniqueWarn("Cannot handle select query: " + select + "\n" + e.toString());
            return Double.MAX_VALUE;
        }
        String modified = SelectHeuristics.addFieldsToSelect(select);
        modified = SelectHeuristics.removeConstraints(modified);
        modified = SelectHeuristics.removeOperations(modified);
        try {
            data = SqlScriptRunner.execCommand(this.connection, modified);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        double dist = SelectHeuristics.computeDistance(select, data);
        if (dist > 0.0) {
            this.emptySqlSelects.add(select);
        }
        return dist;
    }
}

