/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.instrumentation.testability;

import java.lang.reflect.Method;
import java.util.ListIterator;
import java.util.Objects;
import org.evomaster.clientJava.instrumentation.testability.BooleanReplacement;
import shaded.org.objectweb.asm.Type;
import shaded.org.objectweb.asm.tree.AbstractInsnNode;
import shaded.org.objectweb.asm.tree.ClassNode;
import shaded.org.objectweb.asm.tree.JumpInsnNode;
import shaded.org.objectweb.asm.tree.MethodInsnNode;
import shaded.org.objectweb.asm.tree.MethodNode;

public abstract class BooleanMethodTransformer {
    protected final Class<?> target;

    protected BooleanMethodTransformer(Class<?> target) {
        this.target = Objects.requireNonNull(target);
    }

    public Class<?> getTarget() {
        return this.target;
    }

    public void transformClass(ClassNode cn) {
        for (MethodNode mn : cn.methods) {
            this.transformMethod(mn);
        }
    }

    public boolean transformMethod(MethodNode mn) {
        boolean changed = this.replaceBooleanCalls(mn);
        if (!changed) {
            return false;
        }
        AbstractInsnNode node = mn.instructions.getFirst();
        while (node != null) {
            if (!this.isReplaceMethod(node)) {
                node = node.getNext();
                continue;
            }
            AbstractInsnNode next = node.getNext();
            assert (next != null);
            switch (next.getOpcode()) {
                case 154: {
                    this.handleIFNE(next);
                    break;
                }
                case 153: {
                    this.handleIFEQ(next);
                    break;
                }
                case 172: {
                    this.handleIRETURN(mn, next);
                    break;
                }
                case 3: 
                case 4: {
                    this.handleICONST(mn, next);
                    break;
                }
                case 54: {
                    this.handleISTORE(mn, next);
                    break;
                }
                default: {
                    throw new IllegalStateException("Not handled code in testability transformation: " + next.getOpcode());
                }
            }
            node = next.getNext();
        }
        return true;
    }

    private void handleISTORE(MethodNode mn, AbstractInsnNode node) {
        assert (node.getOpcode() == 54);
        assert (this.isReplaceMethod(node.getPrevious()));
        MethodInsnNode n = new MethodInsnNode(184, Type.getInternalName(BooleanMethodTransformer.class), "convertIntToBoolean", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, Type.INT_TYPE), false);
        mn.instructions.insertBefore(node, n);
    }

    private void handleIRETURN(MethodNode mn, AbstractInsnNode node) {
        assert (node.getOpcode() == 172);
        assert (this.isReplaceMethod(node.getPrevious()));
        MethodInsnNode n = new MethodInsnNode(184, Type.getInternalName(BooleanMethodTransformer.class), "convertIntToBoolean", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, Type.INT_TYPE), false);
        mn.instructions.insertBefore(node, n);
    }

    private void handleIFEQ(AbstractInsnNode node) {
        assert (node.getOpcode() == 153);
        assert (this.isReplaceMethod(node.getPrevious()));
        JumpInsnNode branch = (JumpInsnNode)node;
        branch.setOpcode(158);
    }

    private void handleIFNE(AbstractInsnNode node) {
        assert (node.getOpcode() == 154);
        assert (this.isReplaceMethod(node.getPrevious()));
        JumpInsnNode branch = (JumpInsnNode)node;
        branch.setOpcode(157);
    }

    private void handleICONST(MethodNode mn, AbstractInsnNode node) {
        assert (node.getOpcode() == 3 || node.getOpcode() == 4);
        assert (this.isReplaceMethod(node.getPrevious()));
        AbstractInsnNode next = node.getNext();
        assert (next != null);
        if (next.getOpcode() == 159) {
            this.handleIF_ICMPEQ(mn, next);
        } else if (next.getOpcode() == 160) {
            this.handleIF_ICMPNE(mn, next);
        } else {
            throw new IllegalStateException("Cannot handle ICONST case");
        }
    }

    private void handleIF_ICMPNE(MethodNode mn, AbstractInsnNode node) {
        assert (node.getOpcode() == 160);
        assert (this.isReplaceMethod(node.getPrevious().getPrevious()));
        JumpInsnNode branch = (JumpInsnNode)node;
        if (node.getPrevious().getOpcode() == 3) {
            branch.setOpcode(157);
            mn.instructions.remove(node.getPrevious());
        } else if (node.getPrevious().getOpcode() == 4) {
            branch.setOpcode(158);
            mn.instructions.remove(node.getPrevious());
        }
    }

    private void handleIF_ICMPEQ(MethodNode mn, AbstractInsnNode node) {
        assert (node.getOpcode() == 159);
        assert (this.isReplaceMethod(node.getPrevious().getPrevious()));
        JumpInsnNode branch = (JumpInsnNode)node;
        if (node.getPrevious().getOpcode() == 3) {
            branch.setOpcode(158);
            mn.instructions.remove(node.getPrevious());
        } else if (node.getPrevious().getOpcode() == 4) {
            branch.setOpcode(157);
            mn.instructions.remove(node.getPrevious());
        }
    }

    private boolean replaceBooleanCalls(MethodNode mn) {
        boolean changed = false;
        ListIterator<AbstractInsnNode> iterator = mn.instructions.iterator();
        block0: while (iterator.hasNext()) {
            AbstractInsnNode node = iterator.next();
            if (!(node instanceof MethodInsnNode)) continue;
            String replacementClass = Type.getInternalName(this.target);
            MethodInsnNode call = (MethodInsnNode)node;
            if (!call.owner.equals(replacementClass)) continue;
            for (Method m : this.getClass().getMethods()) {
                BooleanReplacement br = m.getAnnotation(BooleanReplacement.class);
                if (br == null || !call.name.equals(m.getName())) continue;
                String paramDesc = BooleanMethodTransformer.getParameterDescriptor(m, false);
                String paramReduced = BooleanMethodTransformer.getParameterDescriptor(m, true);
                if ((!br.replacingStatic() || !call.desc.startsWith(paramDesc)) && (br.replacingStatic() || !call.desc.startsWith(paramReduced))) continue;
                MethodInsnNode replacingCall = new MethodInsnNode(184, Type.getInternalName(this.getClass()), m.getName(), Type.getMethodDescriptor(m), false);
                mn.instructions.insertBefore(node, replacingCall);
                mn.instructions.remove(node);
                changed = true;
                continue block0;
            }
        }
        return changed;
    }

    private static String getParameterDescriptor(Method m, boolean reduced) {
        Class<?>[] parameters = m.getParameterTypes();
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        int start = 0;
        if (reduced) {
            start = 1;
        }
        for (int i = start; i < parameters.length; ++i) {
            buf.append(Type.getDescriptor(parameters[i]));
        }
        buf.append(')');
        return buf.toString();
    }

    private boolean isReplaceMethod(AbstractInsnNode node) {
        if (node == null) {
            return false;
        }
        if (node.getOpcode() == 184) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)node;
            return methodInsnNode.owner.equals(Type.getInternalName(this.getClass()));
        }
        return false;
    }

    public static boolean convertIntToBoolean(int x) {
        return x > 0;
    }
}

