/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.ProtectionDomain;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.ClassName;
import org.evomaster.client.java.instrumentation.ClassScanner;
import org.evomaster.client.java.instrumentation.ClassesToExclude;
import org.evomaster.client.java.instrumentation.Instrumentator;
import org.evomaster.client.java.instrumentation.external.AgentController;
import org.evomaster.client.java.instrumentation.staticstate.ObjectiveRecorder;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.org.objectweb.asm.ClassReader;

public class InstrumentingAgent {
    public static final String EXTERNAL_PORT_PROP = "evomaster.javaagent.external.port";
    public static final String SQL_DRIVER = "evomaster.javaagent.sql.driver";
    public static final String OUTPUT_FILE = "evomaster.javaagent.outputfile";
    private static Instrumentator instrumentator;
    private static String packagePrefixesToCover;
    private static boolean active;

    public static void premain(String args, Instrumentation inst) {
        InstrumentingAgent.agentmain(args, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        String outputFile;
        String sqlDriver;
        packagePrefixesToCover = agentArgs;
        instrumentator = new Instrumentator(packagePrefixesToCover);
        inst.addTransformer(new TransformerForTests());
        active = true;
        String port = System.getProperty(EXTERNAL_PORT_PROP);
        if (port != null) {
            SimpleLogger.info("Starting remote instrumenting Agent for packages: " + agentArgs);
            AgentController.start(Integer.parseInt(port));
        }
        if ((sqlDriver = System.getProperty(SQL_DRIVER)) != null) {
            SimpleLogger.info("Initializing P6SPY with base driver " + sqlDriver);
            InstrumentingAgent.initP6Spy(sqlDriver);
        }
        if ((outputFile = System.getProperty(OUTPUT_FILE)) != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> InstrumentingAgent.saveCoverageToDisk(outputFile)));
        }
    }

    private static void saveCoverageToDisk(String outputFile) {
        try {
            SimpleLogger.info("Going to save coverage data to " + outputFile);
            ClassScanner.forceLoading(packagePrefixesToCover);
            Path path = Paths.get(outputFile, new String[0]);
            Files.deleteIfExists(path);
            Files.createFile(path, new FileAttribute[0]);
            PrintWriter writer = new PrintWriter(outputFile, "UTF-8");
            ObjectiveRecorder.printCoveragePerTarget(writer);
            writer.close();
        }
        catch (IOException e) {
            SimpleLogger.error("Failed to save data to disk: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static void changePackagesToInstrument(String packagePrefixesToCover) {
        instrumentator = new Instrumentator(packagePrefixesToCover);
    }

    public static void initP6Spy(String driver) {
        Objects.requireNonNull(driver);
        System.setProperty("p6spy.config.driverlist", driver);
        System.setProperty("p6spy.config.filter", "true");
        System.setProperty("p6spy.config.include", "select,insert,update,delete");
        System.setProperty("p6spy.config.autoflush", "true");
        System.setProperty("p6spy.config.appender", "com.p6spy.engine.spy.appender.StdoutLogger");
        System.setProperty("p6spy.config.jmx", "false");
        System.setProperty("p6spy.config.logMessageFormat", "org.evomaster.client.java.databasespy.P6SpyFormatter");
    }

    static {
        active = false;
    }

    private static class TransformerForTests
    implements ClassFileTransformer {
        private TransformerForTests() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (!ClassesToExclude.checkIfCanInstrument(ClassName.get(className))) {
                return classfileBuffer;
            }
            ClassReader reader = new ClassReader(classfileBuffer);
            return instrumentator.transformBytes(loader, ClassName.get(className), reader);
        }
    }
}

